/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.renderer;

import com.anthonyhilyard.iceberg.renderer.CheckedBufferSource;
import com.anthonyhilyard.iceberg.renderer.VertexCollector;
import com.anthonyhilyard.iceberg.util.EntityCollector;
import com.anthonyhilyard.iceberg.util.GuiHelper;
import com.anthonyhilyard.iceberg.util.ItemUtil;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1060;
import net.minecraft.class_1087;
import net.minecraft.class_1092;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_148;
import net.minecraft.class_1498;
import net.minecraft.class_1531;
import net.minecraft.class_1723;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2373;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2504;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_276;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_325;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_332;
import net.minecraft.class_3489;
import net.minecraft.class_4059;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_6364;
import net.minecraft.class_756;
import net.minecraft.class_7833;
import net.minecraft.class_7837;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_8251;
import net.minecraft.class_898;
import net.minecraft.class_918;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class CustomItemRenderer
extends class_918 {
    private static class_276 iconFrameBuffer = null;
    private static class_1531 armorStand = null;
    private static class_1498 horse = null;
    private static class_1297 entity = null;
    private static class_2586 blockEntity = null;
    private static Pair<class_1792, class_2487> cachedArmorStandItem = null;
    private static Pair<class_1792, class_2487> cachedHorseArmorItem = null;
    private static Pair<class_1792, class_2487> cachedEntityItem = null;
    private static Pair<class_1792, class_2487> cachedBlockEntityItem = null;
    private static Map<Pair<class_1792, class_2487>, ModelBounds> modelBoundsCache = Maps.newHashMap();
    private static final List<class_2350> quadDirections = new ArrayList<class_2350>(Arrays.asList(class_2350.values()));
    private class_310 minecraft;
    private final class_1092 modelManager;
    private final class_756 blockEntityRenderer;

    public CustomItemRenderer(class_1060 textureManagerIn, class_1092 modelManagerIn, class_325 itemColorsIn, class_756 blockEntityRendererIn, class_310 mcIn) {
        super(mcIn, textureManagerIn, modelManagerIn, itemColorsIn, blockEntityRendererIn);
        this.minecraft = mcIn;
        this.modelManager = modelManagerIn;
        this.blockEntityRenderer = blockEntityRendererIn;
        class_3300 class_33002 = this.minecraft.method_1478();
        if (class_33002 instanceof class_3304) {
            class_3304 resourceManager = (class_3304)class_33002;
            resourceManager.method_14477((class_3302)this);
        }
        if (iconFrameBuffer == null) {
            iconFrameBuffer = new class_6364(96, 96);
            iconFrameBuffer.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
            iconFrameBuffer.method_1230(class_310.field_1703);
        }
    }

    private void renderGuiModel(class_1799 itemStack, int x, int y, Quaternionf rotation, class_1087 bakedModel, class_332 graphics) {
        boolean flatLighting;
        this.minecraft.method_1531().method_4619(class_1723.field_21668).method_4527(false, false);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_4587 modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.method_22903();
        modelViewStack.method_46416((float)x + 8.0f, (float)y + 8.0f, 150.0f);
        modelViewStack.method_34425(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        modelViewStack.method_22905(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        boolean bl = flatLighting = !bakedModel.method_24304();
        if (flatLighting) {
            class_308.method_24210();
        }
        class_4587 poseStack = new class_4587();
        this.renderModel(itemStack, class_811.field_4317, false, poseStack, rotation, (class_4597)bufferSource, 0xF000F0, class_4608.field_21444, bakedModel);
        RenderSystem.disableDepthTest();
        bufferSource.method_22993();
        RenderSystem.enableDepthTest();
        if (flatLighting) {
            class_308.method_24211();
        }
        modelViewStack.method_22909();
        RenderSystem.applyModelViewMatrix();
    }

    private void renderEntityModel(class_1297 entity, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        class_310 minecraft = class_310.method_1551();
        class_898 entityRenderDispatcher = minecraft.method_1561();
        class_308.method_34742();
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        entityRenderDispatcher.method_3948(false);
        poseStack.method_22903();
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        try {
            RenderSystem.runAsFancy(() -> entityRenderDispatcher.method_3954(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, bufferSource, packedLight));
        }
        catch (Exception exception) {
            // empty catch block
        }
        poseStack.method_22909();
        if (bufferSource instanceof class_4597.class_4598) {
            class_4597.class_4598 source = (class_4597.class_4598)bufferSource;
            source.method_22993();
        }
        entityRenderDispatcher.method_3948(true);
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
    }

    /*
     * Unable to fully structure code
     */
    private <T extends class_4597> void renderModelInternal(class_1799 itemStack, class_811 displayContext, boolean leftHanded, class_4587 poseStack, Quaternionf rotation, T bufferSource, int packedLight, int packedOverlay, class_1087 bakedModel, Predicate<T> bufferSourceReady) {
        block18: {
            block16: {
                block17: {
                    minecraft = class_310.method_1551();
                    isArmor = false;
                    if (ItemUtil.getEquipmentSlot(itemStack).method_46643()) {
                        if (this.updateArmorStand(itemStack)) {
                            poseStack.method_22903();
                            poseStack.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
                            this.renderEntityModel((class_1297)CustomItemRenderer.armorStand, poseStack, bufferSource, packedLight);
                            poseStack.method_22909();
                        }
                        isArmor = true;
                    }
                    if (bakedModel.method_4713() || itemStack.method_31574(class_1802.field_8547)) break block16;
                    fabulous = displayContext != class_811.field_4317 && displayContext.method_29998() == false && (var15_13 = itemStack.method_7909()) instanceof class_1747 != false ? (block = (blockItem = (class_1747)var15_13).method_7711()) instanceof class_2373 == false && block instanceof class_2504 == false : true;
                    if (!bufferSourceReady.test(bufferSource) || !((block = itemStack.method_7909()) instanceof class_1747)) break block17;
                    blockItem = (class_1747)block;
                    block = blockItem.method_7711();
                    blockState = block.method_9564();
                    blockModel = missingModel = this.modelManager.method_4744();
                    blockModelShaper = minecraft.method_1541().method_3351();
                    isBlockEntity = false;
                    if (blockState.method_26217() != class_2464.field_11455) {
                        v0 = blockModel = blockState.method_26217() == class_2464.field_11455 ? missingModel : blockModelShaper.method_3335(blockState);
                    }
                    if (blockModel != missingModel) {
                        try {
                            this.blockEntityRenderer.method_3166(itemStack, displayContext, poseStack, bufferSource, packedLight, packedOverlay);
                        }
                        catch (Exception var21_21) {
                            // empty catch block
                        }
                    }
                    if (blockState.method_28498((class_2769)class_2741.field_12533)) {
                        bottomState = (class_2680)blockState.method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12607);
                        bottomModel = blockModelShaper.method_3335(bottomState);
                        this.renderBakedModel(itemStack, displayContext, poseStack, bufferSource, packedLight, packedOverlay, bottomModel, fabulous);
                        poseStack.method_22903();
                        poseStack.method_46416(0.0f, 1.0f, 0.0f);
                        topState = (class_2680)blockState.method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12609);
                        topModel = blockModelShaper.method_3335(topState);
                        this.renderBakedModel(itemStack, displayContext, poseStack, bufferSource, packedLight, packedOverlay, topModel, fabulous);
                        poseStack.method_22909();
                    }
                    if (!(block instanceof class_2343)) ** GOTO lbl-1000
                    entityBlock = (class_2343)block;
                    if (bufferSourceReady.test(bufferSource)) {
                        isBlockEntity = true;
                        try {
                            this.renderBlockEntity(itemStack, poseStack, bufferSource, packedLight, packedOverlay, minecraft, entityBlock, blockState);
                        }
                        catch (Exception var22_24) {}
                    } else lbl-1000:
                    // 2 sources

                    {
                        CustomItemRenderer.blockEntity = null;
                        CustomItemRenderer.cachedBlockEntityItem = null;
                    }
                    if (blockModel != missingModel && (bufferSourceReady.test(bufferSource) || isBlockEntity && !isArmor)) {
                        this.renderBakedModel(itemStack, displayContext, poseStack, bufferSource, packedLight, packedOverlay, blockModel, fabulous);
                    }
                }
                if (bufferSourceReady.test(bufferSource) && EntityCollector.itemCreatesEntity(itemStack, class_1297.class) && this.updateEntity(itemStack)) {
                    this.renderEntityModel(CustomItemRenderer.entity, poseStack, bufferSource, packedLight);
                }
                if (bufferSourceReady.test(bufferSource) && itemStack.method_7909() instanceof class_4059 && this.updateHorseArmor(itemStack)) {
                    this.renderEntityModel((class_1297)CustomItemRenderer.horse, poseStack, bufferSource, packedLight);
                }
                if (bufferSourceReady.test(bufferSource)) {
                    this.renderBakedModel(itemStack, displayContext, poseStack, bufferSource, packedLight, packedOverlay, bakedModel, fabulous);
                }
                break block18;
            }
            if (bufferSourceReady.test(bufferSource)) {
                this.blockEntityRenderer.method_3166(itemStack, displayContext, poseStack, bufferSource, packedLight, packedOverlay);
            }
        }
    }

    private void renderModel(class_1799 itemStack, class_811 displayContext, boolean leftHanded, class_4587 poseStack, Quaternionf rotation, class_4597 bufferSource, int packedLight, int packedOverlay, class_1087 bakedModel) {
        if (!itemStack.method_7960()) {
            class_811 previewContext = displayContext;
            if (!bakedModel.method_4709().method_3501(displayContext)) {
                previewContext = class_811.field_4318;
            }
            boolean isBlockItem = false;
            boolean spawnsEntity = false;
            boolean isArmor = false;
            if (itemStack.method_7909() instanceof class_1747) {
                isBlockItem = true;
            } else if (EntityCollector.itemCreatesEntity(itemStack, class_1297.class)) {
                spawnsEntity = true;
            }
            if (ItemUtil.getEquipmentSlot(itemStack).method_46643()) {
                isArmor = true;
            }
            poseStack.method_22903();
            poseStack.method_46416(0.5f, 0.5f, 0.5f);
            if (isBlockItem || spawnsEntity) {
                poseStack.method_22907(new Quaternionf().rotationXYZ((float)Math.toRadians(30.0), (float)Math.toRadians(225.0), 0.0f));
            } else {
                bakedModel.method_4709().method_3503(previewContext).method_23075(leftHanded, poseStack);
            }
            poseStack.method_46416(-0.5f, -0.5f, -0.5f);
            ModelBounds modelBounds = this.getModelBounds(itemStack, previewContext, leftHanded, poseStack, rotation, bufferSource, packedLight, packedOverlay, bakedModel);
            poseStack.method_22909();
            poseStack.method_22903();
            poseStack.method_22907(rotation);
            float scale = 0.8f / Math.max(modelBounds.height, modelBounds.radius * 2.0f);
            if (isArmor) {
                switch (ItemUtil.getEquipmentSlot(itemStack)) {
                    case field_6169: {
                        scale *= 0.75f;
                        break;
                    }
                    case field_6172: {
                        scale *= 1.3f;
                        break;
                    }
                    case field_6166: {
                        scale *= 0.85f;
                        break;
                    }
                }
            }
            poseStack.method_22905(scale, scale, scale);
            poseStack.method_46416(-modelBounds.center.x(), -modelBounds.center.y(), -modelBounds.center.z());
            poseStack.method_46416(0.5f, 0.5f, 0.5f);
            if (isBlockItem || spawnsEntity) {
                poseStack.method_22907(new Quaternionf().rotationXYZ((float)Math.toRadians(30.0), (float)Math.toRadians(225.0), 0.0f));
            } else {
                bakedModel.method_4709().method_3503(previewContext).method_23075(leftHanded, poseStack);
            }
            poseStack.method_46416(-0.5f, -0.5f, -0.5f);
            CheckedBufferSource checkedBufferSource = CheckedBufferSource.create(bufferSource);
            this.renderModelInternal(itemStack, previewContext, leftHanded, poseStack, rotation, checkedBufferSource, packedLight, packedOverlay, bakedModel, b -> !b.hasRendered());
            poseStack.method_22909();
        }
    }

    private void renderBlockEntity(class_1799 itemStack, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay, class_310 minecraft, class_2343 entityBlock, class_2680 blockState) throws Exception {
        this.updateBlockEntity(itemStack, entityBlock, blockState);
        if (blockEntity != null) {
            minecraft.method_31975().method_23077(blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
        }
    }

    private void renderBakedModel(class_1799 itemStack, class_811 displayContext, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay, class_1087 bakedModel, boolean fabulous) {
        class_4588 vertexConsumer;
        class_1921 renderType = class_4696.method_23678((class_1799)itemStack, (boolean)fabulous);
        if (itemStack.method_31573(class_3489.field_38699) && itemStack.method_7958()) {
            poseStack.method_22903();
            class_4587.class_4665 posestack$pose = poseStack.method_23760();
            if (displayContext == class_811.field_4317) {
                class_7837.method_46414((Matrix4f)posestack$pose.method_23761(), (float)0.5f);
            } else if (displayContext.method_29998()) {
                class_7837.method_46414((Matrix4f)posestack$pose.method_23761(), (float)0.75f);
            }
            vertexConsumer = fabulous ? CustomItemRenderer.method_30115((class_4597)bufferSource, (class_1921)renderType, (class_4587.class_4665)posestack$pose) : CustomItemRenderer.method_30114((class_4597)bufferSource, (class_1921)renderType, (class_4587.class_4665)posestack$pose);
            poseStack.method_22909();
        } else {
            vertexConsumer = fabulous ? CustomItemRenderer.method_29711((class_4597)bufferSource, (class_1921)renderType, (boolean)true, (boolean)itemStack.method_7958()) : CustomItemRenderer.method_23181((class_4597)bufferSource, (class_1921)renderType, (boolean)true, (boolean)itemStack.method_7958());
        }
        this.method_23182(bakedModel, itemStack, packedLight, packedOverlay, poseStack, vertexConsumer);
    }

    private boolean updateArmorStand(class_1799 itemStack) {
        class_1304 equipmentSlot = ItemUtil.getEquipmentSlot(itemStack);
        if (!equipmentSlot.method_46643()) {
            return false;
        }
        if (armorStand == null) {
            class_310 minecraft = class_310.method_1551();
            armorStand = (class_1531)class_1299.field_6131.method_5883((class_1937)minecraft.field_1687);
            armorStand.method_5648(true);
        }
        if (armorStand == null) {
            return false;
        }
        if (cachedArmorStandItem != Pair.of((Object)itemStack.method_7909(), (Object)ItemUtil.getItemNBT(itemStack))) {
            for (class_1304 slot : class_1304.values()) {
                armorStand.method_5673(slot, class_1799.field_8037);
            }
            armorStand.method_5673(equipmentSlot, itemStack);
            cachedArmorStandItem = Pair.of((Object)itemStack.method_7909(), (Object)ItemUtil.getItemNBT(itemStack));
        }
        return true;
    }

    private class_1297 getEntityFromItem(class_1799 itemStack) {
        class_1297 collectedEntity = null;
        List<class_1297> collectedEntities = EntityCollector.collectEntitiesFromItem(itemStack);
        if (!collectedEntities.isEmpty()) {
            collectedEntity = collectedEntities.get(0);
        }
        return collectedEntity;
    }

    private boolean updateEntity(class_1799 itemStack) {
        Pair entityItem = Pair.of((Object)itemStack.method_7909(), (Object)ItemUtil.getItemNBT(itemStack));
        if (entity == null || !entityItem.equals(cachedEntityItem)) {
            entity = this.getEntityFromItem(itemStack);
            cachedEntityItem = entityItem;
        }
        return entity != null;
    }

    private boolean updateBlockEntity(class_1799 itemStack, class_2343 entityBlock, class_2680 blockState) {
        boolean entityChanged = false;
        Pair blockEntityItem = Pair.of((Object)itemStack.method_7909(), (Object)ItemUtil.getItemNBT(itemStack));
        if (blockEntity == null || !blockEntityItem.equals(cachedBlockEntityItem)) {
            blockEntity = entityBlock.method_10123(class_2338.field_10980, blockState);
            if (blockEntity != null && itemStack.method_7985()) {
                blockEntity.method_11014(((class_2487)blockEntityItem.getSecond()).method_10562("BlockEntityTag"));
            }
            cachedBlockEntityItem = blockEntityItem;
            entityChanged = true;
        }
        return entityChanged;
    }

    private boolean updateHorseArmor(class_1799 horseArmorItem) {
        if (!(horseArmorItem.method_7909() instanceof class_4059)) {
            return false;
        }
        if (horse == null) {
            class_310 minecraft = class_310.method_1551();
            horse = (class_1498)class_1299.field_6139.method_5883((class_1937)minecraft.field_1687);
            horse.method_5648(true);
        }
        if (horse == null) {
            return false;
        }
        if (cachedHorseArmorItem != Pair.of((Object)horseArmorItem.method_7909(), (Object)ItemUtil.getItemNBT(horseArmorItem))) {
            horse.method_5673(class_1304.field_6174, horseArmorItem);
            cachedHorseArmorItem = Pair.of((Object)horseArmorItem.method_7909(), (Object)ItemUtil.getItemNBT(horseArmorItem));
        }
        return true;
    }

    private ModelBounds boundsFromVertices(Set<Vector3f> vertices) {
        Vector3f center = new Vector3f();
        float radius = 0.0f;
        float height = 0.0f;
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float minZ = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float maxY = Float.MIN_VALUE;
        float maxZ = Float.MIN_VALUE;
        for (Vector3f vertex : vertices) {
            minX = Math.min(minX, vertex.x);
            minY = Math.min(minY, vertex.y);
            minZ = Math.min(minZ, vertex.z);
            maxX = Math.max(maxX, vertex.x);
            maxY = Math.max(maxY, vertex.y);
            maxZ = Math.max(maxZ, vertex.z);
        }
        center = new Vector3f((minX + maxX) / 2.0f, (minY + maxY) / 2.0f, (minZ + maxZ) / 2.0f);
        height = maxY - minY;
        for (Vector3f vertex : vertices) {
            radius = Math.max(radius, (float)Math.sqrt((vertex.x - center.x) * (vertex.x - center.x) + (vertex.z - center.z) * (vertex.z - center.z)));
        }
        return new ModelBounds(center, height, radius);
    }

    private ModelBounds getModelBounds(class_1799 itemStack, class_811 displayContext, boolean leftHanded, class_4587 poseStack, Quaternionf rotation, class_4597 bufferSource, int packedLight, int packedOverlay, class_1087 bakedModel) {
        Pair key = Pair.of((Object)itemStack.method_7909(), (Object)ItemUtil.getItemNBT(itemStack));
        if (!modelBoundsCache.containsKey(key)) {
            VertexCollector vertexCollector = VertexCollector.create();
            this.renderModelInternal(itemStack, displayContext, leftHanded, poseStack, rotation, vertexCollector, packedLight, packedOverlay, bakedModel, b -> b.getVertices().isEmpty());
            modelBoundsCache.put((Pair<class_1792, class_2487>)key, this.boundsFromVertices(vertexCollector.getVertices()));
        }
        return modelBoundsCache.get(key);
    }

    public void renderDetailModelIntoGUI(class_1799 stack, int x, int y, Quaternionf rotation, class_332 graphics) {
        class_310 minecraft = class_310.method_1551();
        class_1087 bakedModel = minecraft.method_1480().method_4019(stack, (class_1937)minecraft.field_1687, (class_1309)minecraft.field_1724, 0);
        try {
            this.renderGuiModel(stack, x, y, rotation, bakedModel, graphics);
        }
        catch (Throwable throwable) {
            class_128 crashreport = class_128.method_560((Throwable)throwable, (String)"Rendering item");
            class_129 crashreportcategory = crashreport.method_562("Item being rendered");
            crashreportcategory.method_577("Item Type", () -> String.valueOf(stack.method_7909()));
            crashreportcategory.method_577("Registry Name", () -> String.valueOf(class_7923.field_41178.method_10221((Object)stack.method_7909())));
            crashreportcategory.method_577("Item Damage", () -> String.valueOf(stack.method_7919()));
            crashreportcategory.method_577("Item NBT", () -> String.valueOf(stack.method_7969()));
            crashreportcategory.method_577("Item Foil", () -> String.valueOf(stack.method_7958()));
            throw new class_148(crashreport);
        }
    }

    public void renderItemModelIntoGUIWithAlpha(class_4587 poseStack, class_1799 stack, int x, int y, float alpha) {
        boolean flatLighting;
        class_1087 bakedModel = this.minecraft.method_1480().method_4019(stack, null, null, 0);
        class_276 lastFrameBuffer = this.minecraft.method_1522();
        iconFrameBuffer.method_1230(class_310.field_1703);
        iconFrameBuffer.method_1235(true);
        Matrix4f matrix = new Matrix4f();
        matrix.setOrtho(0.0f, (float)CustomItemRenderer.iconFrameBuffer.field_1482, (float)CustomItemRenderer.iconFrameBuffer.field_1481, 0.0f, 1000.0f, 3000.0f);
        RenderSystem.clear((int)256, (boolean)class_310.field_1703);
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)matrix, (class_8251)class_8251.field_43361);
        this.minecraft.method_1531().method_4619(class_1723.field_21668).method_4527(false, false);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_4587 modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.method_22903();
        modelViewStack.method_34426();
        modelViewStack.method_46416(48.0f, 48.0f, -2000.0f);
        modelViewStack.method_22905(96.0f, 96.0f, 96.0f);
        RenderSystem.applyModelViewMatrix();
        class_4597.class_4598 bufferSource = this.minecraft.method_22940().method_23000();
        boolean bl = flatLighting = !bakedModel.method_24304();
        if (flatLighting) {
            class_308.method_24210();
        }
        this.method_23179(stack, class_811.field_4317, false, new class_4587(), (class_4597)bufferSource, 0xF000F0, class_4608.field_21444, bakedModel);
        bufferSource.method_22993();
        RenderSystem.enableDepthTest();
        if (flatLighting) {
            class_308.method_24211();
        }
        modelViewStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.restoreProjectionMatrix();
        if (lastFrameBuffer != null) {
            lastFrameBuffer.method_1235(true);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableCull();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            RenderSystem.setShaderTexture((int)0, (int)iconFrameBuffer.method_30277());
            GuiHelper.blit(poseStack, x, y, 16, 16, 0.0f, 0.0f, CustomItemRenderer.iconFrameBuffer.field_1482, CustomItemRenderer.iconFrameBuffer.field_1481, CustomItemRenderer.iconFrameBuffer.field_1482, CustomItemRenderer.iconFrameBuffer.field_1481);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            iconFrameBuffer.method_1242();
        } else {
            iconFrameBuffer.method_1240();
        }
    }

    public void method_14491(class_3300 resourceManager) {
        super.method_14491(resourceManager);
        modelBoundsCache.clear();
    }

    static {
        quadDirections.add(null);
    }

    private record ModelBounds(Vector3f center, float height, float radius) {
    }
}

