/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.item;

import com.github.wolfiewaffle.hardcore_torches.Mod;
import com.github.wolfiewaffle.hardcore_torches.block.AbstractHardcoreTorchBlock;
import com.github.wolfiewaffle.hardcore_torches.util.ETorchState;
import com.github.wolfiewaffle.hardcore_torches.util.TorchGroup;
import net.fabricmc.fabric.api.item.v1.FabricItem;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1827;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5536;
import net.minecraft.class_5630;

public class TorchItem
extends class_1827
implements FabricItem {
    ETorchState torchState;
    TorchGroup torchGroup;
    int maxFuel;

    public TorchItem(class_2248 standingBlock, class_2248 wallBlock, class_1792.class_1793 settings, ETorchState torchState, int maxFuel, TorchGroup group) {
        super(standingBlock, wallBlock, settings, class_2350.field_11033);
        this.torchState = torchState;
        this.maxFuel = maxFuel;
        this.torchGroup = group;
    }

    public boolean method_31567(class_1799 stack) {
        int fuel = TorchItem.getFuel(stack);
        return fuel > 0 && fuel < this.maxFuel;
    }

    public int method_31569(class_1799 stack) {
        int fuel = TorchItem.getFuel(stack);
        if (this.maxFuel != 0) {
            return Math.round(13.0f - (float)(this.maxFuel - fuel) * 13.0f / (float)this.maxFuel);
        }
        return 0;
    }

    public int method_31571(class_1799 stack) {
        return class_3532.method_15369((float)3.0f, (float)1.0f, (float)1.0f);
    }

    public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        class_2487 oldNbt = null;
        class_2487 newNbt = null;
        if (oldStack.method_7969() != null) {
            oldNbt = oldStack.method_7969().method_10553();
            oldNbt.method_10551("Fuel");
        }
        if (newStack.method_7969() != null) {
            newNbt = newStack.method_7969().method_10553();
            newNbt.method_10551("Fuel");
        }
        if (oldNbt == null && newNbt != null) {
            return true;
        }
        if (oldNbt != null && newNbt == null) {
            return true;
        }
        if (oldNbt == null && newNbt == null) {
            return false;
        }
        return oldNbt.equals(null);
    }

    public class_1269 method_7884(class_1838 context) {
        ETorchState torchState;
        class_1799 stack = context.method_8041();
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2680 state = world.method_8320(pos);
        if (stack.method_7909() instanceof TorchItem && ((torchState = ((TorchItem)stack.method_7909()).torchState) == ETorchState.UNLIT || torchState == ETorchState.SMOLDERING) && state.method_26164(Mod.FREE_TORCH_LIGHT_BLOCKS)) {
            if (state.method_28498((class_2769)class_2741.field_12548) && !((Boolean)state.method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
                return super.method_7884(context);
            }
            class_1657 player = context.method_8036();
            if (player != null && !world.field_9236) {
                player.method_6122(context.method_20287(), TorchItem.stateStack(stack, ETorchState.LIT));
            }
            if (!world.field_9236) {
                world.method_8396(null, pos, class_3417.field_15013, class_3419.field_15245, 0.5f, 1.2f);
            }
            return class_1269.field_5812;
        }
        return super.method_7884(context);
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (!slot.method_32754(player) || !(otherStack.method_7909() instanceof TorchItem) || otherStack.method_7960()) {
            return super.method_31566(stack, otherStack, slot, clickType, player, cursorStackReference);
        }
        if (clickType != class_5536.field_27014 && (stack.method_7947() >= stack.method_7914() || otherStack.method_7947() >= otherStack.method_7914())) {
            return false;
        }
        if (!this.sameTorchGroup((TorchItem)stack.method_7909(), (TorchItem)otherStack.method_7909())) {
            return false;
        }
        if (((TorchItem)stack.method_7909()).torchState == ETorchState.LIT ? ((TorchItem)otherStack.method_7909()).torchState == ETorchState.BURNT : (((TorchItem)stack.method_7909()).torchState == ETorchState.UNLIT ? ((TorchItem)otherStack.method_7909()).torchState != ETorchState.UNLIT : ((TorchItem)stack.method_7909()).torchState == ETorchState.BURNT)) {
            return false;
        }
        if (!otherStack.method_7960()) {
            int max = stack.method_7914();
            int usedCount = clickType != class_5536.field_27014 ? otherStack.method_7947() : 1;
            int otherMax = otherStack.method_7914();
            int remainder = Math.max(0, usedCount - (max - stack.method_7947()));
            int addedNew = usedCount - remainder;
            int stack1Fuel = TorchItem.getFuel(stack) * stack.method_7947();
            int stack2Fuel = TorchItem.getFuel(otherStack) * addedNew;
            int totalFuel = stack1Fuel + stack2Fuel;
            class_2487 nbt = new class_2487();
            nbt.method_10569("Fuel", totalFuel / (stack.method_7947() + addedNew));
            if (addedNew > 0) {
                stack.method_7933(addedNew);
                stack.method_7980(nbt);
                otherStack.method_7939(otherStack.method_7947() - addedNew);
                return true;
            }
        }
        return super.method_31566(stack, otherStack, slot, clickType, player, cursorStackReference);
    }

    public boolean sameTorchGroup(TorchItem item1, TorchItem item2) {
        return item1.torchGroup == item2.torchGroup;
    }

    public static class_1792 stateItem(class_1792 inputItem, ETorchState newState) {
        Object outputItem = class_1802.field_8162;
        if (inputItem instanceof class_1747 && inputItem instanceof TorchItem) {
            AbstractHardcoreTorchBlock newBlock = (AbstractHardcoreTorchBlock)((class_1747)inputItem).method_7711();
            TorchItem newItem = (TorchItem)newBlock.group.getStandingTorch(newState).method_8389();
            outputItem = newItem;
        }
        return outputItem;
    }

    public static class_1799 stateStack(class_1799 inputStack, ETorchState newState) {
        class_1799 outputStack = class_1799.field_8037;
        if (inputStack.method_7909() instanceof class_1747 && inputStack.method_7909() instanceof TorchItem) {
            AbstractHardcoreTorchBlock newBlock = (AbstractHardcoreTorchBlock)((class_1747)inputStack.method_7909()).method_7711();
            TorchItem newItem = (TorchItem)newBlock.group.getStandingTorch(newState).method_8389();
            outputStack = TorchItem.changedCopy(inputStack, (class_1792)newItem);
            if (newState == ETorchState.BURNT) {
                outputStack.method_7980(null);
            }
        }
        return outputStack;
    }

    public static int getFuel(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt != null) {
            return nbt.method_10550("Fuel");
        }
        return Mod.config.defaultTorchFuel;
    }

    public ETorchState getTorchState() {
        return this.torchState;
    }

    public TorchGroup getTorchGroup() {
        return this.torchGroup;
    }

    public static class_1799 changedCopy(class_1799 stack, class_1792 replacementItem) {
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 itemStack = new class_1799((class_1935)replacementItem, stack.method_7947());
        if (stack.method_7969() != null) {
            itemStack.method_7980(stack.method_7969().method_10553());
        }
        return itemStack;
    }

    public static class_1799 addFuel(class_1799 stack, class_1937 world, int amount) {
        if (stack.method_7909() instanceof TorchItem && !world.field_9236) {
            class_2487 nbt = stack.method_7969();
            int fuel = Mod.config.defaultTorchFuel;
            if (nbt != null) {
                fuel = nbt.method_10550("Fuel");
            } else {
                nbt = new class_2487();
            }
            if ((fuel += amount) <= 0) {
                stack = Mod.config.burntStick ? new class_1799((class_1935)class_1802.field_8600, stack.method_7947()) : TorchItem.stateStack(stack, ETorchState.BURNT);
            } else {
                if (fuel > Mod.config.defaultTorchFuel) {
                    fuel = Mod.config.defaultTorchFuel;
                }
                nbt.method_10569("Fuel", fuel);
                stack.method_7980(nbt);
            }
        }
        return stack;
    }
}

