/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.block;

import com.github.wolfiewaffle.hardcore_torches.Mod;
import com.github.wolfiewaffle.hardcore_torches.blockentity.FuelBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.blockentity.IFuelBlock;
import com.github.wolfiewaffle.hardcore_torches.blockentity.LanternBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.item.LanternItem;
import com.github.wolfiewaffle.hardcore_torches.item.OilCanItem;
import com.github.wolfiewaffle.hardcore_torches.util.LanternGroup;
import com.github.wolfiewaffle.hardcore_torches.util.TorchTools;
import java.util.function.IntSupplier;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLanternBlock
extends class_2248
implements class_2343,
IFuelBlock {
    public static final class_2746 HANGING = class_2741.field_16561;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public boolean isLit;
    public IntSupplier maxFuel;
    public LanternGroup group;

    protected AbstractLanternBlock(class_4970.class_2251 settings, boolean isLit, IntSupplier maxFuel) {
        super(settings);
        this.isLit = isLit;
        this.maxFuel = maxFuel;
    }

    public boolean canLight(class_1937 world, class_2338 pos) {
        return ((LanternBlockEntity)world.method_8321(pos)).getFuel() > 0 && !this.isLit;
    }

    public void extinguish(class_1937 world, class_2338 pos, class_2680 state, boolean playSound) {
        if (!world.field_9236) {
            if (playSound) {
                world.method_8396(null, pos, class_3417.field_15102, class_3419.field_15245, 1.0f, 1.0f);
            }
            TorchTools.displayParticle((class_2394)class_2398.field_11237, state, world, pos);
            TorchTools.displayParticle((class_2394)class_2398.field_11237, state, world, pos);
            TorchTools.displayParticle((class_2394)class_2398.field_11251, state, world, pos);
            TorchTools.displayParticle((class_2394)class_2398.field_11251, state, world, pos);
            this.setState(world, pos, false);
        }
    }

    public void light(class_1937 world, class_2338 pos, class_2680 state) {
        if (!world.field_9236) {
            world.method_8396(null, pos, class_3417.field_15013, class_3419.field_15245, 1.0f, 1.0f);
            this.setState(world, pos, true);
        }
    }

    public void setState(class_1937 world, class_2338 pos, boolean lit) {
        class_2680 oldState = world.method_8320(pos);
        class_2680 newState = lit ? Mod.LIT_LANTERN.method_9564() : Mod.UNLIT_LANTERN.method_9564();
        newState = (class_2680)((class_2680)newState.method_11657((class_2769)HANGING, (Comparable)((Boolean)oldState.method_11654((class_2769)HANGING)))).method_11657((class_2769)WATERLOGGED, (Comparable)((Boolean)oldState.method_11654((class_2769)WATERLOGGED)));
        int newFuel = Mod.config.startingLanternFuel;
        if (world.method_8321(pos) != null) {
            newFuel = ((FuelBlockEntity)world.method_8321(pos)).getFuel();
        }
        world.method_8501(pos, newState);
        if (world.method_8321(pos) != null) {
            ((FuelBlockEntity)world.method_8321(pos)).setFuel(newFuel);
        }
    }

    protected class_1799 getStack(class_1937 world, class_2338 pos) {
        class_1799 stack = new class_1799((class_1935)world.method_8320(pos).method_26204().method_8389());
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity != null && blockEntity instanceof FuelBlockEntity) {
            int remainingFuel = ((FuelBlockEntity)blockEntity).getFuel();
            class_2487 nbt = new class_2487();
            nbt.method_10569("Fuel", remainingFuel);
            stack.method_7980(nbt);
        }
        return stack;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        boolean showFuel;
        int oldFuel;
        class_1799 stack = player.method_5998(hand);
        class_2586 be = world.method_8321(pos);
        boolean success = false;
        if (player.method_5715() && Mod.config.pickUpLanterns) {
            if (!world.field_9236) {
                player.method_7270(this.getStack(world, pos));
            }
            world.method_8501(pos, class_2246.field_10124.method_9564());
            if (!world.field_9236) {
                world.method_8396(null, pos, class_3417.field_17743, class_3419.field_15245, 1.0f, 1.0f);
            }
            player.method_6104(hand);
            return class_1269.field_5812;
        }
        if (!this.isLit && this.itemValid(stack, Mod.FREE_LANTERN_LIGHT_ITEMS, Mod.DAMAGE_LANTERN_LIGHT_ITEMS, Mod.CONSUME_LANTERN_LIGHT_ITEMS)) {
            if (((FuelBlockEntity)world.method_8321(pos)).getFuel() < Mod.config.minLanternIgnitionFuel) {
                if (!world.field_9236) {
                    world.method_8396(null, pos, class_3417.field_17742, class_3419.field_15245, 1.0f, 1.0f);
                    player.method_7353(class_2561.method_30163((String)"Not enough fuel to ignite!"), true);
                }
                player.method_6104(hand);
                return class_1269.field_5812;
            }
            if (this.attemptUse(stack, player, hand, Mod.FREE_LANTERN_LIGHT_ITEMS, Mod.DAMAGE_LANTERN_LIGHT_ITEMS, Mod.CONSUME_LANTERN_LIGHT_ITEMS)) {
                this.light(world, pos, state);
                player.method_6104(hand);
                return class_1269.field_5812;
            }
        }
        if (stack.method_31573(class_3489.field_17487) && !Mod.config.lanternsNeedCan && be instanceof FuelBlockEntity && (oldFuel = ((FuelBlockEntity)be).getFuel()) < Mod.config.defaultLanternFuel) {
            if (oldFuel + Mod.config.defLanternFuelItem < Mod.config.defaultLanternFuel) {
                if (!world.field_9236) {
                    world.method_8396(null, pos, class_3417.field_14779, class_3419.field_15245, 1.0f, 1.0f);
                }
            } else if (!world.field_9236) {
                world.method_8396(null, pos, class_3417.field_15126, class_3419.field_15245, 1.0f, 1.0f);
            }
            stack.method_7934(1);
            ((FuelBlockEntity)be).setFuel(Math.min(oldFuel + Mod.config.defLanternFuelItem, Mod.config.defaultLanternFuel));
            player.method_6104(hand);
            return class_1269.field_5812;
        }
        if (stack.method_7909() instanceof OilCanItem && Mod.config.lanternsNeedCan) {
            if (be instanceof FuelBlockEntity && !world.field_9236 && OilCanItem.fuelBlock((FuelBlockEntity)be, world, stack)) {
                world.method_8396(null, pos, class_3417.field_14779, class_3419.field_15245, 1.0f, 1.0f);
            }
            player.method_6104(hand);
            return class_1269.field_5812;
        }
        boolean bl = showFuel = (stack.method_7960() || stack.method_7909() == Mod.OIL_CAN) && Mod.config.fuelMessage;
        if (be.method_11017() == Mod.LANTERN_BLOCK_ENTITY && !world.field_9236 && hand == class_1268.field_5808 && Mod.config.fuelMessage && showFuel) {
            player.method_7353(class_2561.method_30163((String)("Fuel: " + ((FuelBlockEntity)be).getFuel())), true);
        }
        if (Mod.config.lanternsNeedCan && !stack.method_7960() && hand == class_1268.field_5808 && stack.method_7909() != Mod.OIL_CAN && !world.field_9236) {
            player.method_7353(class_2561.method_30163((String)"Requires an Oil Can to fuel!"), true);
        }
        if (Mod.config.handUnlightLantern && this.isLit && !TorchTools.canLight(stack.method_7909(), state)) {
            this.extinguish(world, pos, state, true);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        class_2586 be = world.method_8321(pos);
        if (be != null && be instanceof FuelBlockEntity && itemStack.method_7909() instanceof LanternItem) {
            int fuel = LanternItem.getFuel(itemStack);
            ((FuelBlockEntity)be).setFuel(fuel);
        }
    }

    public static boolean isLightItem(class_1799 stack) {
        if (stack.method_31573(Mod.FREE_LANTERN_LIGHT_ITEMS)) {
            return true;
        }
        if (stack.method_31573(Mod.DAMAGE_LANTERN_LIGHT_ITEMS)) {
            return true;
        }
        return stack.method_31573(Mod.CONSUME_LANTERN_LIGHT_ITEMS);
    }

    @Override
    public void outOfFuel(class_1937 world, class_2338 pos, class_2680 state, boolean playSound) {
        ((AbstractLanternBlock)world.method_8320(pos).method_26204()).extinguish(world, pos, state, playSound);
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.method_9530(state, world, pos, context);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return class_2246.field_16541.method_9530(state, world, pos, context);
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2680 state = class_2246.field_16541.method_9605(ctx);
        class_2680 newState = null;
        if (state != null) {
            newState = (class_2680)((class_2680)this.method_9564().method_11657((class_2769)HANGING, (Comparable)((Boolean)state.method_11654((class_2769)HANGING)))).method_11657((class_2769)WATERLOGGED, (Comparable)((Boolean)state.method_11654((class_2769)WATERLOGGED)));
        }
        return newState;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        return class_2246.field_16541.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return class_2246.field_16541.method_9558(state, world, pos);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{HANGING, WATERLOGGED});
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new LanternBlockEntity(pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return type == Mod.LANTERN_BLOCK_ENTITY ? (world1, pos, state1, be) -> LanternBlockEntity.tick(world1, pos, state1, (LanternBlockEntity)be) : null;
    }
}

