/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import me.jellysquid.mods.sodium.client.compat.ccl.SinkingVertexBuilder;
import me.jellysquid.mods.sodium.client.model.color.ColorProvider;
import me.jellysquid.mods.sodium.client.model.color.ColorProviderRegistry;
import me.jellysquid.mods.sodium.client.model.light.LightMode;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.LightPipelineProvider;
import me.jellysquid.mods.sodium.client.model.light.data.QuadLightData;
import me.jellysquid.mods.sodium.client.model.quad.BakedQuadView;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadOrientation;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockOcclusionCache;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderContext;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.DefaultMaterials;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.Material;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.builder.ChunkMeshBufferBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import me.jellysquid.mods.sodium.client.util.DirectionUtil;
import me.jellysquid.mods.sodium.client.util.ModelQuadUtil;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import net.minecraft.class_777;
import org.embeddedt.embeddium.api.BlockRendererRegistry;
import org.embeddedt.embeddium.render.chunk.ChunkColorWriter;
import org.embeddedt.embeddium.render.frapi.FRAPIModelUtils;
import org.embeddedt.embeddium.render.frapi.FRAPIRenderHandler;
import org.embeddedt.embeddium.render.frapi.IndigoBlockRenderContext;

public class BlockRenderer {
    private static final class_4587 EMPTY_STACK = new class_4587();
    private final class_5819 random = new class_6575(42L);
    private final ColorProviderRegistry colorProviderRegistry;
    private final BlockOcclusionCache occlusionCache;
    private final QuadLightData quadLightData = new QuadLightData();
    private final LightPipelineProvider lighters;
    private final ChunkVertexEncoder.Vertex[] vertices = ChunkVertexEncoder.Vertex.uninitializedQuad();
    private final boolean useAmbientOcclusion;
    private final int[] quadColors = new int[4];
    private boolean useReorienting;
    private final List<BlockRendererRegistry.Renderer> customRenderers = new ObjectArrayList();
    private final SinkingVertexBuilder sinkingVertexBuilder = new SinkingVertexBuilder();
    private final FRAPIRenderHandler fabricModelRenderingHandler;
    private final ChunkColorWriter colorEncoder = ChunkColorWriter.get();

    public BlockRenderer(ColorProviderRegistry colorRegistry, LightPipelineProvider lighters) {
        this.colorProviderRegistry = colorRegistry;
        this.lighters = lighters;
        this.occlusionCache = new BlockOcclusionCache();
        this.useAmbientOcclusion = class_310.method_1588();
        this.fabricModelRenderingHandler = FRAPIRenderHandler.INDIGO_PRESENT ? new IndigoBlockRenderContext(this.occlusionCache, lighters.getLightData()) : null;
    }

    public void renderModel(BlockRenderContext ctx, ChunkBuildBuffers buffers) {
        Material material = DefaultMaterials.forRenderLayer(ctx.renderLayer());
        ChunkModelBuilder meshBuilder = buffers.get(material);
        ColorProvider<class_2680> colorizer = this.colorProviderRegistry.getColorProvider(ctx.state().method_26204());
        LightMode mode = this.getLightingMode(ctx.state(), ctx.model(), ctx.localSlice(), ctx.pos(), ctx.renderLayer());
        LightPipeline lighter = this.lighters.getLighter(mode);
        class_243 renderOffset = ctx.state().method_49228() ? ctx.state().method_26226((class_1922)ctx.localSlice(), ctx.pos()) : class_243.field_1353;
        this.customRenderers.clear();
        BlockRendererRegistry.instance().fillCustomRenderers(this.customRenderers, ctx);
        if (!this.customRenderers.isEmpty()) {
            for (BlockRendererRegistry.Renderer customRenderer : this.customRenderers) {
                this.sinkingVertexBuilder.reset();
                BlockRendererRegistry.RenderResult result = customRenderer.renderBlock(ctx, this.random, this.sinkingVertexBuilder);
                this.sinkingVertexBuilder.flush(meshBuilder, material, ctx.origin());
                if (result != BlockRendererRegistry.RenderResult.OVERRIDE) continue;
                return;
            }
        }
        if (FRAPIModelUtils.isFRAPIModel(ctx.model())) {
            this.fabricModelRenderingHandler.reset();
            this.fabricModelRenderingHandler.renderEmbeddium(ctx, ctx.stack(), this.random);
            this.fabricModelRenderingHandler.flush(buffers, ctx.origin());
            return;
        }
        ctx.maybeUnwrapModel(this.random);
        for (class_2350 face : DirectionUtil.ALL_DIRECTIONS) {
            List<class_777> quads = this.getGeometry(ctx, face);
            if (quads.isEmpty() || !this.isFaceVisible(ctx, face)) continue;
            this.renderQuadList(ctx, material, lighter, colorizer, renderOffset, meshBuilder, quads, face);
        }
        List<class_777> all = this.getGeometry(ctx, null);
        if (!all.isEmpty()) {
            this.renderQuadList(ctx, material, lighter, colorizer, renderOffset, meshBuilder, all, null);
        }
    }

    private List<class_777> getGeometry(BlockRenderContext ctx, class_2350 face) {
        class_5819 random = this.random;
        random.method_43052(ctx.seed());
        return ctx.model().method_4707(ctx.state(), face, random);
    }

    private boolean isFaceVisible(BlockRenderContext ctx, class_2350 face) {
        return this.occlusionCache.shouldDrawSide(ctx.state(), (class_1922)ctx.localSlice(), ctx.pos(), face);
    }

    private void renderQuadList(BlockRenderContext ctx, Material material, LightPipeline lighter, ColorProvider<class_2680> colorizer, class_243 offset, ChunkModelBuilder builder, List<class_777> quads, class_2350 cullFace) {
        this.useReorienting = true;
        int quadsSize = quads.size();
        for (int i = 0; i < quadsSize; ++i) {
            BakedQuadView quad = (BakedQuadView)quads.get(i);
            QuadLightData lightData = this.getVertexLight(ctx, lighter, cullFace, quad);
            int[] vertexColors = this.getVertexColors(ctx, colorizer, quad);
            this.writeGeometry(ctx, builder, offset, material, quad, vertexColors, lightData);
            class_1058 sprite = quad.getSprite();
            if (sprite == null) continue;
            builder.addSprite(sprite);
        }
    }

    private QuadLightData getVertexLight(BlockRenderContext ctx, LightPipeline lighter, class_2350 cullFace, BakedQuadView quad) {
        QuadLightData light = this.quadLightData;
        lighter.calculate(quad, ctx.pos(), light, cullFace, quad.getLightFace(), quad.hasShade());
        return light;
    }

    private int[] getVertexColors(BlockRenderContext ctx, ColorProvider<class_2680> colorProvider, BakedQuadView quad) {
        int[] vertexColors = this.quadColors;
        if (colorProvider != null && quad.hasColor()) {
            colorProvider.getColors(ctx.world(), ctx.pos(), ctx.state(), quad, vertexColors);
            int i = 0;
            while (i < vertexColors.length) {
                int n = i++;
                vertexColors[n] = vertexColors[n] | 0xFF000000;
            }
        } else {
            Arrays.fill(vertexColors, -1);
        }
        return vertexColors;
    }

    private void writeGeometry(BlockRenderContext ctx, ChunkModelBuilder builder, class_243 offset, Material material, BakedQuadView quad, int[] colors, QuadLightData light) {
        ModelQuadOrientation orientation = this.useReorienting ? ModelQuadOrientation.orientByBrightness(light.br, light.lm) : ModelQuadOrientation.NORMAL;
        ChunkVertexEncoder.Vertex[] vertices = this.vertices;
        ModelQuadFacing normalFace = quad.getNormalFace();
        for (int dstIndex = 0; dstIndex < 4; ++dstIndex) {
            int srcIndex = orientation.getVertexIndex(dstIndex);
            ChunkVertexEncoder.Vertex out = vertices[dstIndex];
            out.x = ctx.origin().x() + quad.getX(srcIndex) + (float)offset.method_10216();
            out.y = ctx.origin().y() + quad.getY(srcIndex) + (float)offset.method_10214();
            out.z = ctx.origin().z() + quad.getZ(srcIndex) + (float)offset.method_10215();
            out.color = this.colorEncoder.writeColor(ModelQuadUtil.mixARGBColors(colors[srcIndex], quad.getColor(srcIndex)), light.br[srcIndex]);
            out.u = quad.getTexU(srcIndex);
            out.v = quad.getTexV(srcIndex);
            out.light = ModelQuadUtil.mergeBakedLight(quad.getLight(srcIndex), light.lm[srcIndex]);
        }
        ChunkMeshBufferBuilder vertexBuffer = builder.getVertexBuffer(normalFace);
        vertexBuffer.push(vertices, material);
    }

    private LightMode getLightingMode(class_2680 state, class_1087 model, class_1920 world, class_2338 pos, class_1921 renderLayer) {
        if (this.useAmbientOcclusion && model.method_4708() && state.method_26213() == 0) {
            return LightMode.SMOOTH;
        }
        return LightMode.FLAT;
    }
}

