/*
 * Decompiled with CFR 0.152.
 */
package iDiamondhunter.morebows.config;

import com.google.errorprone.annotations.CompileTimeConstant;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import iDiamondhunter.morebows.MoreBows;
import iDiamondhunter.morebows.config.ConfigBows$BowConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ConfigBows {
    private static final Gson a = new GsonBuilder().setPrettyPrinting().create();
    @CompileTimeConstant
    private static final double a = 1.0;
    @CompileTimeConstant
    private static final float a = 20.0f;
    public final ConfigBows$BowConfig DiamondBow = new ConfigBows$BowConfig(1016, 2.25, 6.0f);
    public final ConfigBows$BowConfig EnderBow = new ConfigBows$BowConfig(215, 1.0, 22.0f);
    public final ConfigBows$BowConfig FlameBow = new ConfigBows$BowConfig(576, 2.0, 15.0f);
    public final ConfigBows$BowConfig FrostBow = new ConfigBows$BowConfig(550, 1.0, 26.0f);
    public final ConfigBows$BowConfig GoldBow = new ConfigBows$BowConfig(68, 2.5, 6.0f);
    public final ConfigBows$BowConfig IronBow = new ConfigBows$BowConfig(550, 1.5, 17.0f);
    public final ConfigBows$BowConfig MultiBow = new ConfigBows$BowConfig(550, 1.0, 13.0f);
    public final ConfigBows$BowConfig StoneBow = new ConfigBows$BowConfig(484, 1.15, 20.0f);

    public static String[] getBowNames() {
        return new String[]{"diamond_bow", "ender_bow", "flame_bow", "frost_bow", "gold_bow", "iron_bow", "multi_bow", "stone_bow"};
    }

    public static ConfigBows getDefaultConfig() {
        return new ConfigBows();
    }

    @NotNull
    public static ConfigBows readConfig() {
        Path path = FabricLoader.getInstance().getConfigDir().resolve("morebows_bowstats.json");
        ConfigBows configBows = new ConfigBows();
        if (path.toFile().exists()) {
            try {
                configBows = (ConfigBows)a.fromJson(Files.readString(path), ConfigBows.class);
            }
            catch (JsonSyntaxException | IOException throwable) {
                MoreBows.modLog.error("Error while reading bow stats config from file", throwable);
                configBows = new ConfigBows();
            }
        }
        return configBows;
    }

    public static void writeConfig(ConfigBows configBows) {
        Path path = FabricLoader.getInstance().getConfigDir().resolve("morebows_bowstats.json");
        try {
            Files.writeString(path, (CharSequence)a.toJson((Object)configBows), new OpenOption[0]);
            return;
        }
        catch (IOException iOException) {
            MoreBows.modLog.error("Error while writing bow stats config to file", (Throwable)iOException);
            return;
        }
    }

    private ConfigBows() {
    }

    public final ConfigBows$BowConfig[] getAllBowConfigs() {
        return new ConfigBows$BowConfig[]{this.DiamondBow, this.EnderBow, this.FlameBow, this.FrostBow, this.GoldBow, this.IronBow, this.MultiBow, this.StoneBow};
    }
}

