/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric.client.keymappings;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.blay09.mods.balm.api.client.keymappings.BalmKeyMappings;
import net.blay09.mods.balm.api.client.keymappings.KeyConflictContext;
import net.blay09.mods.balm.api.client.keymappings.KeyModifier;
import net.blay09.mods.balm.api.client.keymappings.KeyModifiers;
import net.blay09.mods.balm.common.NamespaceResolver;
import net.blay09.mods.balm.common.StaticNamespaceResolver;
import net.blay09.mods.balm.common.client.keymappings.CommonBalmKeyMappings;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import org.jetbrains.annotations.Nullable;

public class FabricBalmKeyMappings
extends CommonBalmKeyMappings {
    private static final Map<class_304, KeyConflictContext> contextAwareKeyMappings = new ConcurrentHashMap<class_304, KeyConflictContext>();

    public FabricBalmKeyMappings(NamespaceResolver namespaceResolver) {
        super(namespaceResolver);
    }

    @Override
    public class_304 registerKeyMapping(String name, KeyConflictContext conflictContext, KeyModifier modifier, class_3675.class_307 type, int keyCode, String category) {
        class_304 keyBinding = new class_304(name, type, keyCode, category);
        contextAwareKeyMappings.put(keyBinding, conflictContext);
        class_304 keyMapping = KeyBindingHelper.registerKeyBinding((class_304)keyBinding);
        if (modifier != KeyModifier.NONE) {
            this.registerModifierKeyMappings(keyMapping, conflictContext, Collections.singletonList(modifier));
        }
        return keyMapping;
    }

    @Override
    public class_304 registerKeyMapping(String name, KeyConflictContext conflictContext, KeyModifiers modifiers, class_3675.class_307 type, int keyCode, String category) {
        List<KeyModifier> keyModifiers = modifiers.asList();
        class_304 keyMapping = new class_304(name, type, keyCode, category);
        contextAwareKeyMappings.put(keyMapping, conflictContext);
        if (!keyModifiers.isEmpty()) {
            this.registerModifierKeyMappings(keyMapping, conflictContext, keyModifiers);
        }
        if (modifiers.hasCustomModifiers()) {
            this.registerCustomModifierKeyMappings(keyMapping, conflictContext, modifiers.getCustomModifiers());
        }
        return KeyBindingHelper.registerKeyBinding((class_304)keyMapping);
    }

    @Override
    public BalmKeyMappings scoped(String modId) {
        return new FabricBalmKeyMappings(new StaticNamespaceResolver(modId));
    }

    private boolean isActiveAndMatchesStrictModifier(@Nullable class_304 keyMapping, int keyCode, int scanCode) {
        return this.isActive(keyMapping) && keyMapping.method_1417(keyCode, scanCode);
    }

    @Override
    protected boolean isContextActive(class_304 keyMapping) {
        KeyConflictContext conflictContext = contextAwareKeyMappings.getOrDefault(keyMapping, KeyConflictContext.UNIVERSAL);
        return this.isContextActive(conflictContext);
    }
}

