/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.mobbattle.items;

import com.google.common.base.Functions;
import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.mobbattle.MobBattle;
import io.github.flemmli97.mobbattle.handler.Utils;
import io.github.flemmli97.mobbattle.items.LeftClickInteractItem;
import io.github.flemmli97.mobbattle.network.S2CSpawnEggScreen;
import io.github.flemmli97.mobbattle.platform.CrossPlatformStuff;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1952;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2404;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5425;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ItemExtendedSpawnEgg
extends class_1792
implements LeftClickInteractItem {
    public ItemExtendedSpawnEgg(class_1792.class_1793 props) {
        super(props);
    }

    public void method_7851(class_1799 stack, class_1937 worldIn, List<class_2561> list, class_1836 flagIn) {
        list.add((class_2561)class_2561.method_43471((String)"tooltip.spawnegg").method_27692(class_124.field_1075));
        class_2960 id = ItemExtendedSpawnEgg.getNamedIdFrom(stack);
        if (id != null) {
            class_1299 type = (class_1299)class_7923.field_41177.method_10223(id);
            class_2487 compound = stack.method_7969().method_10562("mobbattle:Entity");
            list.add((class_2561)class_2561.method_43469((String)("tooltip.spawnegg.spawn" + (compound.method_10546() > 1 ? ".nbt" : "")), (Object[])new Object[]{type.method_5897()}).method_27692(class_124.field_1065));
        }
    }

    @Override
    public boolean onLeftClickEntity(class_1799 stack, class_1657 player, class_1297 entity) {
        class_1309 living = CrossPlatformStuff.INSTANCE.tryGetEntity(entity);
        if (living instanceof class_1308) {
            class_1308 mob = (class_1308)living;
            if (!player.method_7337()) {
                player.method_43496((class_2561)class_2561.method_43471((String)"tooltip.spawnegg.creative").method_27692(class_124.field_1065));
                return true;
            }
            boolean nbt = false;
            class_2487 compound = stack.method_7969();
            if (compound == null) {
                compound = new class_2487();
            }
            class_2487 tag = new class_2487();
            if (player.method_5715()) {
                mob.method_5662(tag);
                this.removeMobSpecifigTags(tag);
                nbt = true;
            } else {
                String name = class_7923.field_41177.method_10221((Object)mob.method_5864()).toString();
                if (name != null) {
                    tag.method_10582("id", name);
                }
            }
            compound.method_10566("mobbattle:Entity", (class_2520)tag);
            stack.method_7980(compound);
            if (!player.method_37908().field_9236) {
                player.method_43496((class_2561)class_2561.method_43469((String)("tooltip.spawnegg.save" + (nbt ? ".nbt" : "")), (Object[])new Object[]{mob.method_5477()}).method_27692(class_124.field_1065));
            }
            return true;
        }
        return false;
    }

    public class_1269 method_7884(class_1838 ctx) {
        class_2586 tile;
        if (ctx.method_8045().field_9236) {
            return class_1269.field_5811;
        }
        class_1799 itemstack = ctx.method_8041();
        if (!ctx.method_8036().method_7343(ctx.method_8037().method_10093(ctx.method_8038()), ctx.method_8038(), itemstack)) {
            return class_1269.field_5811;
        }
        class_2680 iblockstate = ctx.method_8045().method_8320(ctx.method_8037());
        if (ItemExtendedSpawnEgg.hasSavedEntity(itemstack) && (tile = ctx.method_8045().method_8321(ctx.method_8037())) instanceof class_2636) {
            class_2636 spawner = (class_2636)tile;
            class_2487 nbt = new class_2487();
            spawner.method_11390().method_8272(nbt);
            nbt.method_10551("SpawnPotentials");
            nbt.method_10551("SpawnData");
            class_1952.field_34460.encodeStart((DynamicOps)class_2509.field_11560, (Object)new class_1952(itemstack.method_7969().method_10562("mobbattle:Entity"), Optional.empty())).resultOrPartial(string -> MobBattle.LOGGER.warn("Invalid SpawnData: {}", string)).ifPresent(t -> nbt.method_10566("SpawnData", t));
            spawner.method_11390().method_8280(tile.method_10997(), tile.method_11016(), nbt);
            spawner.method_5431();
            ctx.method_8045().method_8413(ctx.method_8037(), iblockstate, iblockstate, 3);
            return class_1269.field_5812;
        }
        class_2338 blockpos = iblockstate.method_26220((class_1922)ctx.method_8045(), ctx.method_8037()).method_1110() ? ctx.method_8037() : ctx.method_8037().method_10093(ctx.method_8038());
        boolean spawned = ItemExtendedSpawnEgg.spawnEntity((class_3218)ctx.method_8045(), itemstack, (double)blockpos.method_10263() + 0.5, blockpos.method_10264(), (double)blockpos.method_10260() + 0.5, ctx.method_8042());
        if (spawned && !ctx.method_8036().method_31549().field_7477) {
            itemstack.method_7934(1);
        }
        return class_1269.field_5812;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        if (!itemstack.method_7985() || !itemstack.method_7969().method_10545("mobbattle:Entity")) {
            return new class_1271(class_1269.field_5811, (Object)itemstack);
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            class_3965 raytraceresult = ItemExtendedSpawnEgg.method_7872((class_1937)world, (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1347);
            if (raytraceresult.method_17783() == class_239.class_240.field_1332) {
                boolean spawned;
                class_2338 blockpos = raytraceresult.method_17777();
                if (!(world.method_8320(blockpos).method_26204() instanceof class_2404)) {
                    return new class_1271(class_1269.field_5811, (Object)itemstack);
                }
                if (world.method_8505(player, blockpos) && player.method_7343(blockpos, raytraceresult.method_17780(), itemstack) && (spawned = ItemExtendedSpawnEgg.spawnEntity((class_3218)world, itemstack, (double)blockpos.method_10263() + 0.5, (double)blockpos.method_10264() + 0.5, (double)blockpos.method_10260() + 0.5, player.method_5735())) && !player.method_31549().field_7477) {
                    itemstack.method_7934(1);
                }
            } else {
                CrossPlatformStuff.INSTANCE.sendToClient(new S2CSpawnEggScreen(hand), serverPlayer);
            }
        }
        return class_1271.method_29237((Object)itemstack, (boolean)player.method_37908().field_9236);
    }

    public static boolean spawnEntity(class_3218 level, class_1799 stack, double x, double y, double z, class_2350 direction) {
        SpawnOptions options = ItemExtendedSpawnEgg.getOptions(stack);
        boolean success = false;
        int sqr = options.amount() > 1 ? (int)Math.ceil(Math.sqrt(options.amount())) : 0;
        for (int i = 0; i < options.amount(); ++i) {
            class_1297 entity = ItemExtendedSpawnEgg.getEntity((class_1937)level, stack);
            if (!(entity instanceof class_1308)) continue;
            class_1308 mob = (class_1308)entity;
            class_2487 tag = stack.method_7969().method_10562("mobbattle:Entity");
            if (options.amount() > 1 && options.spacing() > 0) {
                int dL = i / sqr;
                int dW = i % sqr - sqr / 2;
                class_2382 front = direction.method_10163().method_35862(options.spacing());
                class_2382 side = new class_2382(front.method_10260(), front.method_10264(), -front.method_10263());
                entity.method_5808(x + (double)(side.method_10263() * dW) + (double)(front.method_10263() * dL), y, z + (double)(side.method_10260() * dW) + (double)(front.method_10260() * dL), class_3532.method_15393((float)(direction.method_10144() - 180.0f)), 0.0f);
            } else {
                entity.method_5808(x, y, z, class_3532.method_15393((float)(level.field_9229.method_43057() * 360.0f)), 0.0f);
            }
            mob.field_6241 = mob.method_36454();
            mob.field_6283 = mob.method_36454();
            if (tag.method_10546() == 1) {
                mob.method_5943((class_5425)level, level.method_8404(class_2338.method_49638((class_2374)mob.method_19538())), class_3730.field_16465, null, null);
            }
            level.method_8649(entity);
            mob.method_5966();
            if (options.team() != null && !options.team().isEmpty()) {
                Utils.updateEntity(options.team(), mob);
            }
            if (stack.method_7938()) {
                entity.method_5665(stack.method_7964());
            }
            success = true;
        }
        return success;
    }

    public static class_1297 getEntity(class_1937 level, class_1799 stack) {
        class_1297 entity = null;
        if (ItemExtendedSpawnEgg.hasSavedEntity(stack)) {
            class_2487 tag = stack.method_7969().method_10562("mobbattle:Entity");
            entity = class_1299.method_17842((class_2487)tag, (class_1937)level, (Function)Functions.identity());
        }
        return entity;
    }

    public static SpawnOptions getOptions(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag != null) {
            return new SpawnOptions((tag = tag.method_10562("mobbattle:EntityOptions")).method_10545("Team") ? tag.method_10558("Team") : null, Math.max(1, tag.method_10550("Amount")), Math.max(0, tag.method_10550("Spacing")));
        }
        return new SpawnOptions(null, 1, 0);
    }

    public static void updateOptions(class_1799 stack, SpawnOptions options) {
        class_2487 tag = stack.method_7969();
        if (tag == null) {
            tag = new class_2487();
        }
        class_2487 optionsTag = new class_2487();
        if (options.team() != null && !options.team().isEmpty()) {
            optionsTag.method_10582("Team", options.team());
        }
        if (options.amount() != 1) {
            optionsTag.method_10569("Amount", options.amount());
        }
        if (options.spacing() != 0) {
            optionsTag.method_10569("Spacing", options.spacing());
        }
        if (!optionsTag.method_33133()) {
            tag.method_10566("mobbattle:EntityOptions", (class_2520)optionsTag);
            stack.method_7980(tag);
        }
    }

    private static boolean hasSavedEntity(class_1799 stack) {
        return stack.method_7985() && stack.method_7969().method_10545("mobbattle:Entity") && stack.method_7969().method_10562("mobbattle:Entity").method_10545("id");
    }

    private void removeMobSpecifigTags(class_2487 compound) {
        compound.method_10551("Pos");
        compound.method_10551("Motion");
        compound.method_10551("Rotation");
        compound.method_10551("UUID");
    }

    @Nullable
    public static class_2960 getNamedIdFrom(class_1799 stack) {
        if (ItemExtendedSpawnEgg.hasSavedEntity(stack)) {
            String s = stack.method_7969().method_10562("mobbattle:Entity").method_10558("id");
            class_2960 resourcelocation = new class_2960(s);
            if (!s.contains(":")) {
                stack.method_7969().method_10562("mobbattle:Entity").method_10582("id", resourcelocation.toString());
            }
            return resourcelocation;
        }
        return null;
    }

    public boolean method_7886(class_1799 stack) {
        return ItemExtendedSpawnEgg.hasSavedEntity(stack);
    }

    public record SpawnOptions(@Nullable String team, int amount, int spacing) {
        public SpawnOptions(@Nullable String team, int amount, int spacing) {
            this.team = team;
            this.amount = class_3532.method_15340((int)amount, (int)0, (int)100);
            this.spacing = class_3532.method_15340((int)spacing, (int)0, (int)99);
        }
    }
}

