/*
 * Decompiled with CFR 0.152.
 */
package supercoder79.chunkpregen;

import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1923;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_3193;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import net.minecraft.class_3898;
import net.minecraft.server.MinecraftServer;
import supercoder79.chunkpregen.ChunkPregen;
import supercoder79.chunkpregen.iterator.CoarseOnionIterator;

public final class PregenerationTask {
    private static final int BATCH_SIZE = 32;
    private static final int QUEUE_THRESHOLD = 8;
    private static final int COARSE_CELL_SIZE = 4;
    private final MinecraftServer server;
    private final class_3215 chunkManager;
    private final Iterator<class_1923> iterator;
    private final int x;
    private final int z;
    private final int totalCount;
    private final Object queueLock = new Object();
    private final AtomicInteger queuedCount = new AtomicInteger();
    private final AtomicInteger okCount = new AtomicInteger();
    private final AtomicInteger errorCount = new AtomicInteger();
    private volatile Listener listener;
    private volatile boolean stopped;

    public PregenerationTask(class_3218 world, int x, int z, int radius) {
        this.server = world.method_8503();
        this.chunkManager = world.method_14178();
        this.iterator = new CoarseOnionIterator(radius, 4);
        this.x = x;
        this.z = z;
        int diameter = radius * 2 + 1;
        this.totalCount = diameter * diameter;
    }

    public int getOkCount() {
        return this.okCount.get();
    }

    public int getErrorCount() {
        return this.errorCount.get();
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void run(Listener listener) {
        if (this.listener != null) {
            throw new IllegalStateException("already running!");
        }
        this.listener = listener;
        this.tryEnqueueTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.queueLock;
        synchronized (object) {
            this.stopped = true;
            this.listener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryEnqueueTasks() {
        Object object = this.queueLock;
        synchronized (object) {
            if (this.stopped) {
                return;
            }
            int enqueueCount = 32 - this.queuedCount.get();
            if (enqueueCount <= 0) {
                return;
            }
            LongList chunks = this.collectChunks(enqueueCount);
            if (chunks.isEmpty()) {
                this.listener.complete(this.errorCount.get());
                this.stopped = true;
                return;
            }
            this.queuedCount.getAndAdd(chunks.size());
            this.server.method_20493(() -> this.enqueueChunks(chunks));
        }
    }

    private void enqueueChunks(LongList chunks) {
        for (int i = 0; i < chunks.size(); ++i) {
            long chunk = chunks.getLong(i);
            this.acquireChunk(chunk);
        }
        this.chunkManager.method_16155();
        class_3898 tacs = this.chunkManager.field_17254;
        for (int i = 0; i < chunks.size(); ++i) {
            long chunk = chunks.getLong(i);
            class_3193 holder = tacs.method_17216(chunk);
            if (holder == null) {
                ChunkPregen.LOGGER.warn("Added ticket for chunk but it was not added! ({}; {})", (Object)class_1923.method_8325((long)chunk), (Object)class_1923.method_8332((long)chunk));
                this.acceptChunkResult(chunk, (Either<class_2791, class_3193.class_3724>)class_3193.field_16426);
                continue;
            }
            holder.method_13993(class_2806.field_12803, tacs).whenComplete((result, throwable) -> {
                if (throwable == null) {
                    this.acceptChunkResult(chunk, (Either<class_2791, class_3193.class_3724>)result);
                } else {
                    ChunkPregen.LOGGER.warn("Encountered unexpected error while generating chunk", throwable);
                    this.acceptChunkResult(chunk, (Either<class_2791, class_3193.class_3724>)class_3193.field_16426);
                }
            });
        }
    }

    private void acceptChunkResult(long chunk, Either<class_2791, class_3193.class_3724> result) {
        this.server.method_20493(() -> this.releaseChunk(chunk));
        if (result.left().isPresent()) {
            this.okCount.getAndIncrement();
        } else {
            this.errorCount.getAndIncrement();
        }
        this.listener.update(this.okCount.get(), this.errorCount.get(), this.totalCount);
        int queuedCount = this.queuedCount.decrementAndGet();
        if (queuedCount <= 8) {
            this.tryEnqueueTasks();
        }
    }

    private LongList collectChunks(int count) {
        LongArrayList chunks = new LongArrayList(count);
        Iterator<class_1923> iterator = this.iterator;
        for (int i = 0; i < count && iterator.hasNext(); ++i) {
            class_1923 chunk = iterator.next();
            chunks.add(class_1923.method_8331((int)(chunk.field_9181 + this.x), (int)(chunk.field_9180 + this.z)));
        }
        return chunks;
    }

    private void acquireChunk(long chunk) {
        class_1923 pos = new class_1923(chunk);
        this.chunkManager.method_17297(class_3230.field_14031, pos, 0, (Object)pos);
    }

    private void releaseChunk(long chunk) {
        class_1923 pos = new class_1923(chunk);
        this.chunkManager.method_17300(class_3230.field_14031, pos, 0, (Object)pos);
    }

    public static interface Listener {
        public void update(int var1, int var2, int var3);

        public void complete(int var1);
    }
}

