/*
 * Decompiled with CFR 0.152.
 */
package voidedmirror.FancySporeBlossom.block.entity;

import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2672;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractFancySporeBlossomBlockEntity
extends class_2586 {
    public static final String DISPLAY_KEY = "display";
    public static final String COLOR_KEY = "color";
    public static final String GLOWING_KEY = "glowing";
    public static final int DEFAULT_COLOR = 0xFFFFFF;
    private int color = 0xFFFFFF;
    private boolean glowing = false;

    public AbstractFancySporeBlossomBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void method_11014(@NotNull class_2487 tag) {
        super.method_11014(tag);
        this.color = tag.method_10550(COLOR_KEY);
        this.glowing = tag.method_10577(GLOWING_KEY);
    }

    public void method_11007(class_2487 tag) {
        tag.method_10569(COLOR_KEY, this.color);
        tag.method_10556(GLOWING_KEY, this.glowing);
        super.method_11007(tag);
    }

    public void readStackNbt(class_1799 stack) {
        class_2487 tag = stack.method_7941(DISPLAY_KEY);
        if (tag != null) {
            if (tag.method_10573(COLOR_KEY, 99)) {
                this.color = tag.method_10550(COLOR_KEY);
            }
            if (tag.method_10545(GLOWING_KEY)) {
                this.glowing = tag.method_10577(GLOWING_KEY);
            }
        }
    }

    public void writeStackNbt(class_1799 stack) {
        class_2487 tag = new class_2487();
        tag.method_10569(COLOR_KEY, this.color);
        tag.method_10556(GLOWING_KEY, this.glowing);
        stack.method_7959(DISPLAY_KEY, (class_2520)tag);
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
        this.markUpdated();
    }

    public void mixColor(float[] diffuseColors) {
        int[] colorArray = new int[3];
        int oldColor = this.getColor();
        float blue = (float)(oldColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(oldColor >> 8 & 0xFF) / 255.0f;
        float red = (float)(oldColor & 0xFF) / 255.0f;
        int maxValue = (int)(Math.max(blue, Math.max(green, red)) * 255.0f);
        colorArray[0] = colorArray[0] + (int)(blue * 255.0f);
        colorArray[1] = colorArray[1] + (int)(green * 255.0f);
        colorArray[2] = colorArray[2] + (int)(red * 255.0f);
        int r = (int)(diffuseColors[0] * 255.0f);
        int g = (int)(diffuseColors[1] * 255.0f);
        int b = (int)(diffuseColors[2] * 255.0f);
        maxValue += Math.max(r, Math.max(g, b));
        colorArray[0] = colorArray[0] + r;
        colorArray[1] = colorArray[1] + g;
        colorArray[2] = colorArray[2] + b;
        int redNorm = colorArray[0] / 2;
        int greenNorm = colorArray[1] / 2;
        int blueNorm = colorArray[2] / 2;
        float maxNormValue = (float)maxValue / 2.0f;
        float maxNorm = Math.max(redNorm, Math.max(greenNorm, blueNorm));
        redNorm = (int)((float)redNorm * maxNormValue / maxNorm);
        greenNorm = (int)((float)greenNorm * maxNormValue / maxNorm);
        blueNorm = (int)((float)blueNorm * maxNormValue / maxNorm);
        int colorOut = redNorm;
        colorOut = (colorOut << 8) + greenNorm;
        colorOut = (colorOut << 8) + blueNorm;
        this.setColor(colorOut);
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public void setGlowing(boolean glowing) {
        this.glowing = glowing;
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887() {
        class_2487 tag = new class_2487();
        this.method_11007(tag);
        return tag;
    }

    private void markUpdated() {
        this.method_5431();
        for (class_1657 player : this.field_11863.method_18456()) {
            if (!(player instanceof class_3222)) continue;
            class_3222 sPlayer = (class_3222)player;
            sPlayer.field_13987.method_14364((class_2596)new class_2672(this.field_11863.method_8500(this.method_11016()), this.field_11863.method_22336(), null, null));
        }
    }
}

