/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.v3.rendering.ui.widget.slider;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.mixin.client.IMixinAbstractSliderButton;
import de.keksuccino.fancymenu.v3.rendering.DrawableColor;
import de.keksuccino.fancymenu.v3.rendering.RenderingUtils;
import de.keksuccino.fancymenu.v3.rendering.ui.UIBase;
import de.keksuccino.fancymenu.v3.rendering.ui.widget.UniqueWidget;
import de.keksuccino.konkrete.input.MouseInput;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExtendedSliderButton
extends class_357
implements UniqueWidget {
    protected static final class_2960 SLIDER_LOCATION = new class_2960("textures/gui/slider.png");
    protected static boolean leftDownGlobal = false;
    public boolean handleClick;
    public boolean enableRightClick = false;
    public boolean ignoreBlockedInput = false;
    public boolean ignoreGlobalLeftMouseDown = false;
    protected String messagePrefix = null;
    protected String messageSuffix = null;
    protected Consumer<ExtendedSliderButton> applyValueCallback;
    @Nullable
    protected DrawableColor backgroundColor = null;
    @Nullable
    protected DrawableColor borderColor = null;
    @Nullable
    protected DrawableColor handleColorNormal = null;
    @Nullable
    protected DrawableColor handleColorHover = null;
    @NotNull
    protected DrawableColor labelColorNormal = DrawableColor.of(new Color(0xFFFFFF));
    @NotNull
    protected DrawableColor labelColorInactive = DrawableColor.of(new Color(0xA0A0A0));
    protected boolean labelShadow = true;
    @Nullable
    protected String identifier;
    protected boolean leftDownNotHovered = false;
    protected boolean leftDownThis = false;

    public ExtendedSliderButton(int x, int y, int width, int height, boolean handleClick, double value, Consumer<ExtendedSliderButton> applyValueCallback) {
        super(x, y, width, height, class_5244.field_39003, value);
        this.handleClick = handleClick;
        this.applyValueCallback = applyValueCallback;
    }

    public void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        this.renderBackground(graphics);
        this.renderHandle(graphics);
        int labelColorInt = this.field_22763 ? this.labelColorNormal.getColorInt() : this.labelColorInactive.getColorInt();
        this.renderScrollingLabel(graphics, class_310.method_1551().field_1772, 2, labelColorInt | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
        RenderingUtils.resetShaderColor();
    }

    protected void renderHandle(@NotNull class_332 graphics) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        int handleX = this.method_46426() + (int)(this.field_22753 * (double)(this.field_22758 - 8));
        DrawableColor c = this.getHandleRenderColor();
        if (c == null) {
            graphics.method_51422(1.0f, 1.0f, 1.0f, this.field_22765);
            graphics.method_49697(SLIDER_LOCATION, this.method_46426() + (int)(this.field_22753 * (double)(this.field_22758 - 8)), this.method_46427(), 8, 20, 20, 4, 200, 20, 0, this.getHandleTextureY());
        } else {
            graphics.method_25294(handleX, this.method_46427(), handleX + 8, this.method_46427() + this.method_25364(), RenderingUtils.replaceAlphaInColor(c.getColorInt(), this.field_22765));
        }
        RenderingUtils.resetShaderColor();
    }

    @Nullable
    protected DrawableColor getHandleRenderColor() {
        if (this.field_22762 && this.handleColorHover != null) {
            return this.handleColorHover;
        }
        return this.handleColorNormal;
    }

    protected void renderBackground(@NotNull class_332 graphics) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        if (this.backgroundColor == null) {
            graphics.method_51422(1.0f, 1.0f, 1.0f, this.field_22765);
            graphics.method_49697(SLIDER_LOCATION, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), 20, 4, 200, 20, 0, this.getTextureY());
        } else {
            int borderOffset = this.borderColor != null ? 1 : 0;
            graphics.method_25294(this.method_46426() + borderOffset, this.method_46427() + borderOffset, this.method_46426() + this.method_25368() - borderOffset, this.method_46427() + this.method_25364() - borderOffset, RenderingUtils.replaceAlphaInColor(this.backgroundColor.getColorInt(), this.field_22765));
            if (this.borderColor != null) {
                UIBase.renderBorder(graphics.method_51448(), this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), 1, this.borderColor, true, true, true, true);
            }
        }
        RenderingUtils.resetShaderColor();
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (this.field_22764) {
            boolean bl = this.field_22762 = mouseX >= this.field_22760 && mouseY >= this.field_22761 && mouseX < this.field_22760 + this.field_22758 && mouseY < this.field_22761 + this.field_22759;
            if (!this.method_25367() && MouseInput.isLeftMouseDown()) {
                this.leftDownNotHovered = true;
            }
            if (!MouseInput.isLeftMouseDown()) {
                this.leftDownNotHovered = false;
            }
            if (this.handleClick) {
                if (this.method_25367() && (MouseInput.isLeftMouseDown() || this.enableRightClick && MouseInput.isRightMouseDown()) && (!leftDownGlobal || this.ignoreGlobalLeftMouseDown) && !this.leftDownNotHovered && !this.isInputBlocked() && this.field_22763 && this.field_22764 && !this.leftDownThis) {
                    this.method_25348(mouseX, mouseY);
                    leftDownGlobal = true;
                    this.leftDownThis = true;
                }
                if (!(MouseInput.isLeftMouseDown() || MouseInput.isRightMouseDown() && this.enableRightClick)) {
                    leftDownGlobal = false;
                    if (this.leftDownThis) {
                        this.method_25357(mouseX, mouseY);
                    }
                    this.leftDownThis = false;
                }
                if (this.leftDownThis) {
                    this.method_25349(mouseX, mouseY, 0.0, 0.0);
                }
            }
        }
        super.method_25394(graphics, mouseX, mouseY, partial);
    }

    protected void renderScrollingLabel(@NotNull class_332 graphics, @NotNull class_327 font, int spaceLeftRight, int textColor) {
        int xMin = this.method_46426() + spaceLeftRight;
        int xMax = this.method_46426() + this.method_25368() - spaceLeftRight;
        this.renderScrollingLabelInternal(graphics, font, this.method_25369(), xMin, this.method_46427(), xMax, this.method_46427() + this.method_25364(), textColor);
    }

    protected void renderScrollingLabelInternal(@NotNull class_332 graphics, class_327 font, @NotNull class_2561 text, int xMin, int yMin, int xMax, int yMax, int textColor) {
        int textWidth = font.method_27525((class_5348)text);
        int textPosY = (yMin + yMax - 9) / 2 + 1;
        int maxTextWidth = xMax - xMin;
        if (textWidth > maxTextWidth) {
            int diffTextWidth = textWidth - maxTextWidth;
            double scrollTime = (double)class_156.method_658() / 1000.0;
            double $$13 = Math.max((double)diffTextWidth * 0.5, 3.0);
            double $$14 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * scrollTime / $$13)) / 2.0 + 0.5;
            double textPosX = class_3532.method_16436((double)$$14, (double)0.0, (double)diffTextWidth);
            graphics.method_44379(xMin, yMin, xMax, yMax);
            graphics.method_51439(font, text, xMin - (int)textPosX, textPosY, textColor, this.labelShadow);
            graphics.method_44380();
        } else {
            graphics.method_51439(font, text, (int)((float)(xMin + xMax) / 2.0f - (float)font.method_27525((class_5348)text) / 2.0f), textPosY, textColor, this.labelShadow);
        }
    }

    @Nullable
    public DrawableColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(@Nullable DrawableColor backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Nullable
    public DrawableColor getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(@Nullable DrawableColor borderColor) {
        this.borderColor = borderColor;
    }

    @Nullable
    public DrawableColor getHandleColorNormal() {
        return this.handleColorNormal;
    }

    public void setHandleColorNormal(@Nullable DrawableColor handleColorNormal) {
        this.handleColorNormal = handleColorNormal;
    }

    @Nullable
    public DrawableColor getHandleColorHover() {
        return this.handleColorHover;
    }

    public void setHandleColorHover(@Nullable DrawableColor handleColorHover) {
        this.handleColorHover = handleColorHover;
    }

    @NotNull
    public DrawableColor getLabelColorNormal() {
        return this.labelColorNormal;
    }

    public void setLabelColorNormal(@NotNull DrawableColor labelColorNormal) {
        this.labelColorNormal = labelColorNormal;
    }

    @NotNull
    public DrawableColor getLabelColorInactive() {
        return this.labelColorInactive;
    }

    public void setLabelColorInactive(@NotNull DrawableColor labelColorInactive) {
        this.labelColorInactive = labelColorInactive;
    }

    public boolean isLabelShadow() {
        return this.labelShadow;
    }

    public void setLabelShadow(boolean labelShadow) {
        this.labelShadow = labelShadow;
    }

    public boolean canChangeValue() {
        return this.getAccessor().getCanChangeValueFancyMenu();
    }

    public IMixinAbstractSliderButton getAccessor() {
        return (IMixinAbstractSliderButton)((Object)this);
    }

    protected int getTextureY() {
        int $$0 = this.method_25370() && !this.canChangeValue() ? 1 : 0;
        return $$0 * 20;
    }

    protected int getHandleTextureY() {
        int $$0 = !this.field_22762 && !this.canChangeValue() ? 2 : 3;
        return $$0 * 20;
    }

    protected void method_25349(double mouseX, double mouseY, double d1, double d2) {
        super.method_25349(mouseX, mouseY, d1, d2);
    }

    public void method_25348(double mouseX, double mouseY) {
        super.method_25348(mouseX, mouseY);
    }

    public void method_25357(double mouseX, double mouseY) {
        super.method_25357(mouseX, mouseY);
    }

    protected void method_25344() {
        if (this.applyValueCallback != null) {
            this.applyValueCallback.accept(this);
        }
    }

    public void method_25346() {
        Object s = "";
        if (this.messagePrefix != null) {
            s = (String)s + this.messagePrefix;
        }
        s = (String)s + this.getSliderMessageWithoutPrefixSuffix();
        if (this.messageSuffix != null) {
            s = (String)s + this.messageSuffix;
        }
        this.method_25355((class_2561)class_2561.method_43470((String)s));
    }

    public abstract String getSliderMessageWithoutPrefixSuffix();

    public void setLabelPrefix(String prefix) {
        this.messagePrefix = prefix;
        this.method_25346();
    }

    public void setLabelSuffix(String suffix) {
        this.messageSuffix = suffix;
        this.method_25346();
    }

    public void setValue(double value) {
        double d0 = this.field_22753;
        this.field_22753 = class_3532.method_15350((double)value, (double)0.0, (double)1.0);
        if (d0 != this.field_22753) {
            this.method_25344();
        }
        this.method_25346();
    }

    public double getValue() {
        return this.field_22753;
    }

    protected boolean isInputBlocked() {
        if (this.ignoreBlockedInput) {
            return false;
        }
        return MouseInput.isVanillaInputBlocked();
    }

    @Override
    @Nullable
    public String getWidgetIdentifierFancyMenu() {
        return this.identifier;
    }

    public ExtendedSliderButton setWidgetIdentifierFancyMenu(@Nullable String identifier) {
        this.identifier = identifier;
        return this;
    }
}

