/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.v3.rendering.ui.widget.editbox;

import de.keksuccino.fancymenu.mixin.client.IMixinEditBox;
import de.keksuccino.fancymenu.v3.input.CharacterFilter;
import de.keksuccino.fancymenu.v3.rendering.DrawableColor;
import de.keksuccino.fancymenu.v3.rendering.ui.UIBase;
import de.keksuccino.fancymenu.v3.rendering.ui.widget.UniqueWidget;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendedEditBox
extends class_342
implements UniqueWidget {
    protected CharacterFilter characterFilter;
    protected CharacterRenderFormatter characterRenderFormatter;
    protected DrawableColor backgroundColor = DrawableColor.of(new Color(0, 0, 0));
    protected DrawableColor borderNormalColor = DrawableColor.of(new Color(-6250336));
    protected DrawableColor borderFocusedColor = DrawableColor.of(new Color(255, 255, 255));
    protected DrawableColor textColor = DrawableColor.of(new Color(0xE0E0E0));
    protected DrawableColor textColorUneditable = DrawableColor.of(new Color(0x707070));
    protected DrawableColor suggestionTextColor = DrawableColor.of(new Color(-8355712));
    protected boolean textShadow = true;
    protected final class_327 font;
    @Nullable
    protected String identifier;

    public ExtendedEditBox(class_327 font, int x, int y, int width, int height, class_2561 hint) {
        super(font, x, y, width, height, hint);
        this.font = font;
    }

    public ExtendedEditBox(class_327 font, int x, int y, int width, int height, @Nullable class_342 editBox, class_2561 hint) {
        super(font, x, y, width, height, editBox, hint);
        this.font = font;
    }

    public void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        IMixinEditBox access = (IMixinEditBox)((Object)this);
        boolean bordered = access.getBorderedFancyMenu();
        if (this.method_1885()) {
            class_2561 hint;
            graphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, this.backgroundColor.getColorInt());
            if (bordered) {
                int borderColor = this.method_25370() ? this.borderFocusedColor.getColorInt() : this.borderNormalColor.getColorInt();
                UIBase.renderBorder(graphics.method_51448(), (float)(this.method_46426() - 1), (float)(this.method_46427() - 1), (float)(this.method_46426() + this.field_22758 + 1), (float)(this.method_46427() + this.field_22759 + 1), 1.0f, borderColor, true, true, true, true);
            }
            int textColor = access.getIsEditableFancyMenu() ? this.textColor.getColorInt() : this.textColorUneditable.getColorInt();
            int cursorPos = this.method_1881() - access.getDisplayPosFancyMenu();
            int highlightPos = access.getHighlightPosFancyMenu() - access.getDisplayPosFancyMenu();
            String text = this.font.method_27523(this.method_1882().substring(access.getDisplayPosFancyMenu()), this.method_1859());
            boolean isCursorInsideVisibleText = cursorPos >= 0 && cursorPos <= text.length();
            boolean isCursorVisible = this.method_25370() && access.getFrameFancyMenu() / 6 % 2 == 0 && isCursorInsideVisibleText;
            int textX = bordered ? this.method_46426() + 4 : this.method_46426();
            int textY = bordered ? this.method_46427() + (this.field_22759 - 8) / 2 : this.method_46427();
            int textXAfterCursor = textX;
            if (highlightPos > text.length()) {
                highlightPos = text.length();
            }
            int textCharacterRenderIndex = access.getDisplayPosFancyMenu();
            if (!text.isEmpty()) {
                String textBeforeCursor = isCursorInsideVisibleText ? text.substring(0, cursorPos) : text;
                class_5250 beforeCursorComp = class_2561.method_43470((String)"");
                if (this.characterRenderFormatter == null) {
                    beforeCursorComp = class_2561.method_43470((String)textBeforeCursor);
                } else {
                    for (char c : textBeforeCursor.toCharArray()) {
                        class_5250 comp = this.characterRenderFormatter.formatComponent(this, class_2561.method_43470((String)String.valueOf(c)), textCharacterRenderIndex, c, text, this.method_1882());
                        beforeCursorComp.method_10852((class_2561)comp);
                        ++textCharacterRenderIndex;
                    }
                }
                textXAfterCursor = graphics.method_51439(this.font, (class_2561)beforeCursorComp, textX, textY, textColor, this.textShadow);
            }
            boolean renderSmallCursor = this.method_1881() < this.method_1882().length() || this.method_1882().length() >= access.getMaxLengthFancyMenu();
            int finalTextXAfterCursor = textXAfterCursor;
            if (!isCursorInsideVisibleText) {
                finalTextXAfterCursor = cursorPos > 0 ? textX + this.field_22758 : textX;
            } else if (renderSmallCursor) {
                finalTextXAfterCursor = textXAfterCursor - 1;
                if (this.textShadow) {
                    --textXAfterCursor;
                }
            }
            if (!text.isEmpty() && isCursorInsideVisibleText && cursorPos < text.length()) {
                String textAfterCursor = text.substring(cursorPos);
                class_5250 afterCursorComp = class_2561.method_43470((String)"");
                if (this.characterRenderFormatter == null) {
                    afterCursorComp = class_2561.method_43470((String)textAfterCursor);
                } else {
                    for (char c : textAfterCursor.toCharArray()) {
                        class_5250 comp = this.characterRenderFormatter.formatComponent(this, class_2561.method_43470((String)String.valueOf(c)), textCharacterRenderIndex, c, text, this.method_1882());
                        afterCursorComp.method_10852((class_2561)comp);
                        ++textCharacterRenderIndex;
                    }
                }
                graphics.method_51439(this.font, (class_2561)afterCursorComp, textXAfterCursor, textY, textColor, this.textShadow);
            }
            if ((hint = access.getHintFancyMenu()) != null && text.isEmpty() && !this.method_25370()) {
                graphics.method_51439(this.font, hint, textXAfterCursor, textY, textColor, this.textShadow);
            }
            if (!renderSmallCursor && access.getSuggestionFancyMenu() != null) {
                graphics.method_51433(this.font, access.getSuggestionFancyMenu(), finalTextXAfterCursor - 1, textY, this.suggestionTextColor.getColorInt(), this.textShadow);
            }
            if (isCursorVisible) {
                if (renderSmallCursor) {
                    graphics.method_25294(finalTextXAfterCursor, textY - 1, finalTextXAfterCursor + 1, textY + 1 + 9, textColor);
                } else {
                    Objects.requireNonNull(this.font);
                    Objects.requireNonNull(this.font);
                    graphics.method_25294(finalTextXAfterCursor, textY + 9 - 2, finalTextXAfterCursor + 5, textY + 9 - 1, textColor);
                }
            }
            if (highlightPos != cursorPos) {
                int l1 = textX + this.font.method_1727(text.substring(0, highlightPos));
                access.invokeRenderHighlightFancyMenu(graphics, finalTextXAfterCursor, textY - 1, l1 - 1, textY + 1 + 9);
            }
        }
    }

    public void setHeight(int height) {
        this.field_22759 = height;
    }

    public int getDisplayPosition() {
        return ((IMixinEditBox)((Object)this)).getDisplayPosFancyMenu();
    }

    public void setDisplayPosition(int position) {
        ((IMixinEditBox)((Object)this)).setDisplayPosFancyMenu(position);
    }

    @Nullable
    public CharacterFilter getCharacterFilter() {
        return this.characterFilter;
    }

    public ExtendedEditBox setCharacterFilter(@Nullable CharacterFilter characterFilter) {
        this.characterFilter = characterFilter;
        return this;
    }

    public boolean hasTextShadow() {
        return this.textShadow;
    }

    public ExtendedEditBox setTextShadow(boolean textShadow) {
        this.textShadow = textShadow;
        return this;
    }

    @NotNull
    public DrawableColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public ExtendedEditBox setBackgroundColor(@NotNull DrawableColor backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @NotNull
    public DrawableColor getBorderNormalColor() {
        return this.borderNormalColor;
    }

    public ExtendedEditBox setBorderNormalColor(@NotNull DrawableColor borderNormalColor) {
        this.borderNormalColor = borderNormalColor;
        return this;
    }

    @NotNull
    public DrawableColor getBorderFocusedColor() {
        return this.borderFocusedColor;
    }

    public ExtendedEditBox setBorderFocusedColor(@NotNull DrawableColor borderFocusedColor) {
        this.borderFocusedColor = borderFocusedColor;
        return this;
    }

    @Nullable
    public CharacterRenderFormatter getCharacterRenderFormatter() {
        return this.characterRenderFormatter;
    }

    public ExtendedEditBox setCharacterRenderFormatter(@Nullable CharacterRenderFormatter characterRenderFormatter) {
        this.characterRenderFormatter = characterRenderFormatter;
        return this;
    }

    @NotNull
    public DrawableColor getTextColor() {
        return this.textColor;
    }

    public ExtendedEditBox setTextColor(@NotNull DrawableColor textColor) {
        this.textColor = textColor;
        return this;
    }

    @NotNull
    public DrawableColor getTextColorUneditable() {
        return this.textColorUneditable;
    }

    public ExtendedEditBox setTextColorUneditable(@NotNull DrawableColor textColorUneditable) {
        this.textColorUneditable = textColorUneditable;
        return this;
    }

    @NotNull
    public DrawableColor getSuggestionTextColor() {
        return this.suggestionTextColor;
    }

    public ExtendedEditBox setSuggestionTextColor(@NotNull DrawableColor suggestionTextColor) {
        this.suggestionTextColor = suggestionTextColor;
        return this;
    }

    @Deprecated
    public void method_1868(int color) {
        this.textColor = DrawableColor.of(new Color(color));
    }

    @Deprecated
    public void method_1860(int color) {
        this.textColorUneditable = DrawableColor.of(new Color(color));
    }

    public boolean method_25400(char character, int modifiers) {
        if (this.characterFilter != null && !this.characterFilter.isAllowedChar(character)) {
            return false;
        }
        return super.method_25400(character, modifiers);
    }

    public void method_1867(@NotNull String textToWrite) {
        if (this.characterFilter != null) {
            textToWrite = this.characterFilter.filterForAllowedChars(textToWrite);
        }
        super.method_1867(textToWrite);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return false;
    }

    public ExtendedEditBox setWidgetIdentifierFancyMenu(@Nullable String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Override
    @Nullable
    public String getWidgetIdentifierFancyMenu() {
        return this.identifier;
    }

    @FunctionalInterface
    public static interface CharacterRenderFormatter {
        @NotNull
        public class_5250 formatComponent(@NotNull ExtendedEditBox var1, @NotNull class_5250 var2, int var3, char var4, @NotNull String var5, @NotNull String var6);
    }
}

