/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.menu.fancy.helper.CustomizationHelper;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.fancymenu.menu.placeholder.v2.PlaceholderParser;
import de.keksuccino.konkrete.annotations.OptifineFix;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.resources.TextureHandler;
import de.keksuccino.konkrete.resources.WebTextureResourceLocation;
import java.awt.Color;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class WebTextureCustomizationItem
extends CustomizationItemBase {
    public static Map<String, WebTextureResourceLocation> cachedWebImages = new HashMap<String, WebTextureResourceLocation>();
    public volatile WebTextureResourceLocation texture;
    public String rawURL = "";
    public volatile boolean ready = false;

    @OptifineFix
    public WebTextureCustomizationItem(PropertiesSection item) {
        super(item);
        if (this.action != null && this.action.equalsIgnoreCase("addwebtexture")) {
            this.value = item.getEntryValue("url");
            if (this.value != null) {
                this.rawURL = this.value;
                this.value = StringUtils.convertFormatCodes((String)PlaceholderParser.replacePlaceholders(this.value), (String)"\u00a7", (String)"&");
                if (this.getWidth() <= 0 && this.getHeight() <= 0) {
                    this.setWidth(100);
                }
                if (cachedWebImages.containsKey(this.actionId)) {
                    this.texture = cachedWebImages.get(this.actionId);
                    this.calculateAspectRatio();
                    if (this.texture != null && this.texture.getResourceLocation() != null && this.texture.getURL() != null && this.texture.getURL().equals(this.value)) {
                        this.ready = true;
                    } else {
                        this.texture = null;
                    }
                }
                if (this.texture == null) {
                    new Thread(() -> {
                        try {
                            if (WebTextureCustomizationItem.isValidUrl(this.value)) {
                                long currentTime;
                                this.texture = TextureHandler.getWebResource((String)this.value, (boolean)false);
                                CustomizationHelper.runTaskInMainThread(() -> {
                                    try {
                                        this.texture.loadTexture();
                                        cachedWebImages.put(this.actionId, this.texture);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                });
                                long startTime = System.currentTimeMillis();
                                while (!(startTime + 15000L < (currentTime = System.currentTimeMillis()) || this.texture.isReady() && this.texture.getResourceLocation() != null)) {
                                    try {
                                        Thread.sleep(100L);
                                    }
                                    catch (Exception exception) {}
                                }
                                if (this.texture != null && this.texture.getResourceLocation() == null) {
                                    this.texture = null;
                                    FancyMenu.LOGGER.error("[FANCYMENU] Web texture loaded but resource location was still null! Unable to use web texture!");
                                }
                                this.calculateAspectRatio();
                            }
                            this.ready = true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }).start();
                }
            }
        }
    }

    protected void calculateAspectRatio() {
        if (this.texture == null || !this.texture.isReady()) {
            if (this.getWidth() <= 0) {
                this.setWidth(100);
            }
            if (this.getHeight() <= 0) {
                this.setHeight(100);
            }
            this.ready = true;
            return;
        }
        int w = this.texture.getWidth();
        int h = this.texture.getHeight();
        double ratio = (double)w / (double)h;
        if (this.getWidth() < 0 && this.getHeight() >= 0) {
            this.setWidth((int)((double)this.getHeight() * ratio));
        }
        if (this.getHeight() < 0 && this.getWidth() >= 0) {
            this.setHeight((int)((double)this.getWidth() / ratio));
        }
    }

    @Override
    public void render(class_332 graphics, class_437 menu) throws IOException {
        if (this.shouldRender() || WebTextureCustomizationItem.isEditorActive()) {
            int x = this.getPosX(menu);
            int y = this.getPosY(menu);
            if (this.isTextureReady()) {
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
                graphics.method_25290(this.texture.getResourceLocation(), x, y, 0.0f, 0.0f, this.getWidth(), this.getHeight(), this.getWidth(), this.getHeight());
                RenderSystem.disableBlend();
            } else if (WebTextureCustomizationItem.isEditorActive()) {
                graphics.method_25294(this.getPosX(menu), this.getPosY(menu), this.getPosX(menu) + this.getWidth(), this.getPosY(menu) + this.getHeight(), Color.MAGENTA.getRGB());
                if (this.ready) {
                    class_327 class_3272 = class_310.method_1551().field_1772;
                    int n = this.getPosX(menu) + this.getWidth() / 2;
                    int n2 = this.getPosY(menu) + this.getHeight() / 2;
                    Objects.requireNonNull(class_310.method_1551().field_1772);
                    graphics.method_25300(class_3272, "\u00a7lMISSING", n, n2 - 9 / 2, -1);
                }
            }
            if (!this.ready && WebTextureCustomizationItem.isEditorActive()) {
                class_327 class_3273 = class_310.method_1551().field_1772;
                int n = this.getPosX(menu) + this.getWidth() / 2;
                int n3 = this.getPosY(menu) + this.getHeight() / 2;
                Objects.requireNonNull(class_310.method_1551().field_1772);
                graphics.method_25300(class_3273, "\u00a7lLOADING TEXTURE..", n, n3 - 9 / 2, -1);
            }
        }
    }

    public boolean isTextureReady() {
        return this.texture != null && this.texture.isReady() && this.texture.getResourceLocation() != null && this.ready;
    }

    @Override
    public boolean shouldRender() {
        if (this.getWidth() < 0 || this.getHeight() < 0) {
            return false;
        }
        return super.shouldRender();
    }

    public static boolean isValidUrl(String url) {
        if (url != null && (url.startsWith("http://") || url.startsWith("https://"))) {
            try {
                URL u = new URL(url);
                HttpURLConnection c = (HttpURLConnection)u.openConnection();
                c.addRequestProperty("User-Agent", "Mozilla/4.0");
                c.setRequestMethod("HEAD");
                int r = c.getResponseCode();
                if (r == 200) {
                    return true;
                }
            }
            catch (Exception e1) {
                try {
                    URL u = new URL(url);
                    HttpURLConnection c = (HttpURLConnection)u.openConnection();
                    c.addRequestProperty("User-Agent", "Mozilla/4.0");
                    int r = c.getResponseCode();
                    if (r == 200) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
        return false;
    }
}

