/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.profile;

import com.google.common.collect.Lists;
import com.mojang.authlib.properties.Property;
import customskinloader.profile.ModelManager0;
import customskinloader.utils.TextureUtil;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class UserProfile {
    public static final UserProfile NULL = new UserProfile();
    public String skinUrl = null;
    public String model = null;
    public String capeUrl = null;
    public String elytraUrl = null;

    public void put(ModelManager0.Model model, String url) {
        if (model == null || StringUtils.isEmpty((CharSequence)url)) {
            return;
        }
        switch (model) {
            case SKIN_DEFAULT: {
                this.skinUrl = url;
                this.model = "default";
                return;
            }
            case SKIN_SLIM: {
                this.skinUrl = url;
                this.model = "slim";
                return;
            }
            case CAPE: {
                this.capeUrl = url;
                return;
            }
            case ELYTRA: {
                this.elytraUrl = url;
            }
        }
    }

    public String toString() {
        return this.toString(0L);
    }

    public String toString(long expiry) {
        return "(SkinUrl: " + this.skinUrl + " , Model: " + this.model + " , CapeUrl: " + this.capeUrl + (StringUtils.isBlank((CharSequence)this.elytraUrl) ? " " : " , ElytraUrl: " + this.elytraUrl) + (expiry == 0L ? "" : " , Expiry: " + expiry) + ")";
    }

    public List<Property> toProperties() {
        return Lists.newArrayList((Object[])new Property[]{new Property("skinUrl", UserProfile.nullToValue(this.skinUrl)), new Property("model", UserProfile.nullToValue(this.model)), new Property("capeUrl", UserProfile.nullToValue(this.capeUrl)), new Property("elytraUrl", UserProfile.nullToValue(this.elytraUrl))});
    }

    public static UserProfile fromProperties(Collection<Property> properties) {
        UserProfile profile = new UserProfile();
        if (properties != null) {
            for (Property property : properties) {
                switch ((String)TextureUtil.AuthlibField.PROPERTY_NAME.get(property)) {
                    case "skinUrl": {
                        profile.skinUrl = UserProfile.nullToValue((String)TextureUtil.AuthlibField.PROPERTY_VALUE.get(property));
                        break;
                    }
                    case "model": {
                        profile.model = UserProfile.nullToValue((String)TextureUtil.AuthlibField.PROPERTY_VALUE.get(property));
                        break;
                    }
                    case "capeUrl": {
                        profile.capeUrl = UserProfile.nullToValue((String)TextureUtil.AuthlibField.PROPERTY_VALUE.get(property));
                        break;
                    }
                    case "elytraUrl": {
                        profile.elytraUrl = UserProfile.nullToValue((String)TextureUtil.AuthlibField.PROPERTY_VALUE.get(property));
                    }
                }
            }
        }
        return profile;
    }

    private static String nullToValue(String value) {
        return value == null ? "null" : (value.equals("null") ? null : value);
    }

    public boolean isEmpty() {
        return StringUtils.isEmpty((CharSequence)this.skinUrl) && StringUtils.isEmpty((CharSequence)this.capeUrl) && StringUtils.isEmpty((CharSequence)this.elytraUrl);
    }

    public boolean isFull() {
        return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.skinUrl, this.capeUrl});
    }

    public boolean hasSkinUrl() {
        return StringUtils.isNotEmpty((CharSequence)this.skinUrl);
    }

    public void mix(UserProfile profile) {
        if (profile == null) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)this.skinUrl)) {
            this.skinUrl = profile.skinUrl;
            this.model = profile.model;
        }
        if (StringUtils.isEmpty((CharSequence)this.capeUrl)) {
            this.capeUrl = profile.capeUrl;
        }
        if (StringUtils.isEmpty((CharSequence)this.elytraUrl)) {
            this.elytraUrl = profile.elytraUrl;
        }
    }
}

