/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.mixin;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftProfileTextures;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import customskinloader.fake.FakeSkinManager;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import net.minecraft.class_1060;
import net.minecraft.class_1071;
import net.minecraft.class_8685;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Group;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

public abstract class MixinSkinManager {

    @Mixin(value={class_1071.class})
    public static abstract class V6 {
        @Inject(method={"Lnet/minecraft/client/resources/SkinManager;getInsecureSkin(Lcom/mojang/authlib/GameProfile;Lnet/minecraft/client/resources/PlayerSkin;)Lnet/minecraft/client/resources/PlayerSkin;"}, at={@At(value="HEAD")})
        private void inject_getInsecureSkin(GameProfile profile, class_8685 skin, CallbackInfoReturnable<?> callbackInfoReturnable) {
            FakeSkinManager.setSkullType(profile);
        }

        @Inject(method={"Lnet/minecraft/client/resources/SkinManager;registerTextures(Ljava/util/UUID;Lcom/mojang/authlib/minecraft/MinecraftProfileTextures;)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="RETURN")}, cancellable=true)
        private void inject_registerTextures(UUID uuid, MinecraftProfileTextures textures, CallbackInfoReturnable<CompletableFuture<?>> callbackInfoReturnable) {
            callbackInfoReturnable.setReturnValue(FakeSkinManager.checkIncompleted(textures, (CompletableFuture)callbackInfoReturnable.getReturnValue()));
        }
    }

    @Mixin(value={class_1071.class})
    public static abstract class V5 {
        @Inject(method={"Lnet/minecraft/client/resources/SkinManager;<init>(Ljava/nio/file/Path;Lcom/mojang/authlib/minecraft/MinecraftSessionService;Ljava/util/concurrent/Executor;)V"}, at={@At(value="RETURN")})
        private void inject_init(Path path, MinecraftSessionService minecraftSessionService, Executor executor, CallbackInfo callbackInfo) {
            FakeSkinManager.setSkinCacheDir(path);
        }

        @ModifyArg(method={"Lnet/minecraft/client/resources/SkinManager;<init>(Ljava/nio/file/Path;Lcom/mojang/authlib/minecraft/MinecraftSessionService;Ljava/util/concurrent/Executor;)V"}, at=@At(value="INVOKE", target="Lcom/google/common/cache/CacheBuilder;build(Lcom/google/common/cache/CacheLoader;)Lcom/google/common/cache/LoadingCache;", remap=false))
        private CacheLoader<Object, ?> modifyArg_init(CacheLoader<Object, ?> cacheLoader) {
            return FakeSkinManager.setCacheLoader(cacheLoader);
        }

        @ModifyVariable(method={"Lnet/minecraft/client/resources/SkinManager;lambda$registerTextures$1(Ljava/util/concurrent/CompletableFuture;Ljava/lang/String;Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/CompletableFuture;Lnet/minecraft/client/resources/PlayerSkin$Model;Lcom/mojang/authlib/minecraft/MinecraftProfileTextures;Ljava/lang/Void;)Lnet/minecraft/client/resources/PlayerSkin;"}, at=@At(value="HEAD"), argsOnly=true)
        private static class_8685.class_7920 modifyVariable_lambda$registerTextures$1(class_8685.class_7920 model, CompletableFuture<?> skin, String url, CompletableFuture<?> cape, CompletableFuture<?> elytra, class_8685.class_7920 _model, MinecraftProfileTextures textures) {
            return FakeSkinManager.loadSkinModel(model, textures);
        }
    }

    @Mixin(value={class_1071.class})
    public static abstract class V4 {
        @ModifyArg(method={"Lnet/minecraft/client/resources/SkinManager;getOrLoad(Lcom/mojang/authlib/GameProfile;)Ljava/util/concurrent/CompletableFuture;"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/resources/SkinManager$CacheKey;<init>(Ljava/util/UUID;Lcom/mojang/authlib/properties/Property;)V"))
        private Property modifyArg_getOrLoad(Property property) {
            return FakeSkinManager.createProperty(property);
        }
    }

    @Mixin(value={class_1071.class})
    public static abstract class V3 {
        @Inject(method={"Lnet/minecraft/client/resources/SkinManager;getInsecureSkin(Lcom/mojang/authlib/GameProfile;)Lnet/minecraft/client/resources/PlayerSkin;"}, at={@At(value="HEAD")})
        private void inject_getInsecureSkin(GameProfile profile, CallbackInfoReturnable<?> callbackInfoReturnable) {
            FakeSkinManager.setSkullType(profile);
        }

        @Redirect(method={"Lnet/minecraft/client/resources/SkinManager;getOrLoad(Lcom/mojang/authlib/GameProfile;)Ljava/util/concurrent/CompletableFuture;"}, at=@At(value="INVOKE", target="Lcom/google/common/cache/LoadingCache;getUnchecked(Ljava/lang/Object;)Ljava/lang/Object;", remap=false))
        private Object redirect_getOrLoad(LoadingCache<?, ?> loadingCache, Object cacheKey, GameProfile profile) throws Exception {
            return FakeSkinManager.loadCache(loadingCache, cacheKey, profile);
        }
    }

    @Mixin(value={class_1071.class})
    public static abstract class V2 {
        @Inject(method={"Lnet/minecraft/client/resources/SkinManager;<init>(Lnet/minecraft/client/renderer/texture/TextureManager;Ljava/nio/file/Path;Lcom/mojang/authlib/minecraft/MinecraftSessionService;Ljava/util/concurrent/Executor;)V"}, at={@At(value="RETURN")})
        private void inject_init(class_1060 textureManager, Path path, MinecraftSessionService minecraftSessionService, Executor executor, CallbackInfo callbackInfo) {
            FakeSkinManager.setSkinCacheDir(path);
        }

        @ModifyArg(method={"Lnet/minecraft/client/resources/SkinManager;<init>(Lnet/minecraft/client/renderer/texture/TextureManager;Ljava/nio/file/Path;Lcom/mojang/authlib/minecraft/MinecraftSessionService;Ljava/util/concurrent/Executor;)V"}, at=@At(value="INVOKE", target="Lcom/google/common/cache/CacheBuilder;build(Lcom/google/common/cache/CacheLoader;)Lcom/google/common/cache/LoadingCache;", remap=false))
        private CacheLoader<Object, ?> modifyArg_init(CacheLoader<Object, ?> cacheLoader) {
            return FakeSkinManager.setCacheLoader(cacheLoader);
        }
    }

    @Mixin(value={class_1071.class})
    public static abstract class V1 {
        @Inject(method={"Lnet/minecraft/client/resources/SkinManager;<init>(Lnet/minecraft/client/renderer/texture/TextureManager;Ljava/io/File;Lcom/mojang/authlib/minecraft/MinecraftSessionService;)V"}, at={@At(value="RETURN")})
        private void inject_init(class_1060 textureManagerInstance, File skinCacheDirectory, MinecraftSessionService sessionService, CallbackInfo callbackInfo) {
            FakeSkinManager.setSkinCacheDir(skinCacheDirectory);
        }

        @ModifyArgs(method={"Lnet/minecraft/client/resources/SkinManager;loadSkin(Lcom/mojang/authlib/minecraft/MinecraftProfileTexture;Lcom/mojang/authlib/minecraft/MinecraftProfileTexture$Type;Lnet/minecraft/client/resources/SkinManager$SkinAvailableCallback;)Lnet/minecraft/util/ResourceLocation;"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/ThreadDownloadImageData;<init>(Ljava/io/File;Ljava/lang/String;Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/client/renderer/IImageBuffer;)V"))
        @Group(name="modifyArgs_loadSkin", min=1)
        private void modifyArgs_loadSkin_0(Args args, MinecraftProfileTexture profileTexture, MinecraftProfileTexture.Type textureType, class_1071.class_1072 skinAvailableCallback) {
            Object[] argsArr = new Object[args.size()];
            for (int i = 0; i < argsArr.length; ++i) {
                argsArr[i] = args.get(i);
            }
            argsArr = FakeSkinManager.createThreadDownloadImageData((ImmutableList<Object>)ImmutableList.copyOf((Object[])argsArr), profileTexture, textureType);
            args.setAll(argsArr);
        }

        @ModifyArgs(method={"Lnet/minecraft/client/resources/SkinManager;loadSkin(Lcom/mojang/authlib/minecraft/MinecraftProfileTexture;Lcom/mojang/authlib/minecraft/MinecraftProfileTexture$Type;Lnet/minecraft/client/resources/SkinManager$SkinAvailableCallback;)Lnet/minecraft/util/ResourceLocation;"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/ThreadDownloadImageData;<init>(Ljava/io/File;Ljava/lang/String;Lnet/minecraft/util/ResourceLocation;ZLjava/lang/Runnable;)V"))
        @Group(name="modifyArgs_loadSkin", min=1)
        private void modifyArgs_loadSkin_1(Args args, MinecraftProfileTexture profileTexture, MinecraftProfileTexture.Type textureType, class_1071.class_1072 skinAvailableCallback) {
            this.modifyArgs_loadSkin_0(args, profileTexture, textureType, skinAvailableCallback);
        }

        @Redirect(method={"Lnet/minecraft/client/resources/SkinManager;loadProfileTextures(Lcom/mojang/authlib/GameProfile;Lnet/minecraft/client/resources/SkinManager$SkinAvailableCallback;Z)V"}, at=@At(value="INVOKE", target="Ljava/util/concurrent/ExecutorService;submit(Ljava/lang/Runnable;)Ljava/util/concurrent/Future;", remap=false))
        @Group(name="redirect_loadProfileTextures", min=1)
        private Future<?> redirect_loadProfileTextures_0(ExecutorService executor, Runnable task, GameProfile profile, class_1071.class_1072 skinAvailableCallback, boolean requireSecure) {
            FakeSkinManager.loadProfileTextures(task, profile);
            return null;
        }

        @Redirect(method={"Lnet/minecraft/client/resources/SkinManager;loadProfileTextures(Lcom/mojang/authlib/GameProfile;Lnet/minecraft/client/resources/SkinManager$SkinAvailableCallback;Z)V"}, at=@At(value="INVOKE", target="Ljava/util/concurrent/Executor;execute(Ljava/lang/Runnable;)V", remap=false))
        @Group(name="redirect_loadProfileTextures", min=1)
        private void redirect_loadProfileTextures_1(Executor executor, Runnable task, GameProfile profile, class_1071.class_1072 skinAvailableCallback, boolean requireSecure) {
            FakeSkinManager.loadProfileTextures(task, profile);
        }

        @Redirect(method={"Lnet/minecraft/client/resources/SkinManager;loadProfileTextures(Lcom/mojang/authlib/GameProfile;Lnet/minecraft/client/resources/SkinManager$SkinAvailableCallback;Z)V"}, at=@At(value="INVOKE", target="Ljava/util/concurrent/ExecutorService;execute(Ljava/lang/Runnable;)V", remap=false))
        @Group(name="redirect_loadProfileTextures", min=1)
        private void redirect_loadProfileTextures_2(ExecutorService executor, Runnable task, GameProfile profile, class_1071.class_1072 skinAvailableCallback, boolean requireSecure) {
            FakeSkinManager.loadProfileTextures(task, profile);
        }

        @Inject(method={"Lnet/minecraft/client/resources/SkinManager;loadSkinFromCache(Lcom/mojang/authlib/GameProfile;)Ljava/util/Map;"}, at={@At(value="HEAD")}, cancellable=true)
        private void inject_loadSkinFromCache(GameProfile profile, CallbackInfoReturnable<Map<MinecraftProfileTexture.Type, MinecraftProfileTexture>> callbackInfoReturnable) {
            callbackInfoReturnable.setReturnValue(FakeSkinManager.loadSkinFromCache(profile));
        }

        @Redirect(method={"Lnet/minecraft/client/resources/SkinManager;func_210275_a(Lcom/mojang/authlib/GameProfile;ZLnet/minecraft/client/resources/SkinManager$SkinAvailableCallback;)V"}, at=@At(value="INVOKE", target="Lcom/mojang/authlib/minecraft/MinecraftSessionService;getTextures(Lcom/mojang/authlib/GameProfile;Z)Ljava/util/Map;", remap=false))
        private Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> redirect_func_210275_a(MinecraftSessionService sessionService, GameProfile profile, boolean requireSecure) {
            return FakeSkinManager.getUserProfile(sessionService, profile, requireSecure);
        }

        @Inject(method={"Lnet/minecraft/client/resources/SkinManager;func_210276_a(Ljava/util/Map;Lnet/minecraft/client/resources/SkinManager$SkinAvailableCallback;)V"}, at={@At(value="INVOKE", target="Ljava/util/Map;containsKey(Ljava/lang/Object;)Z", ordinal=0, remap=false)})
        @Group(name="loadElytraTexture", min=1)
        private void inject_func_210276_a(Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> map, class_1071.class_1072 skinAvailableCallback, CallbackInfo callbackInfo) {
            FakeSkinManager.loadElytraTexture((class_1071)this, map, skinAvailableCallback);
        }

        @Redirect(method={"Lnet/minecraft/client/resources/SkinManager;func_210276_a(Ljava/util/Map;Lnet/minecraft/client/resources/SkinManager$SkinAvailableCallback;)V"}, at=@At(value="INVOKE", target="Lcom/google/common/collect/ImmutableList;of(Ljava/lang/Object;Ljava/lang/Object;)Lcom/google/common/collect/ImmutableList;", remap=false))
        @Group(name="loadElytraTexture", min=1)
        private ImmutableList<MinecraftProfileTexture.Type> redirect_func_229297_b_(Object e1, Object e2) {
            return ImmutableList.copyOf((Object[])MinecraftProfileTexture.Type.values());
        }
    }
}

