/*
 * Decompiled with CFR 0.152.
 */
package io.github.adytech99.healthindicators.config;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    private static final Gson GSON = new Gson();
    private static Config INSTANCE = new Config();
    private boolean renderingEnabled = true;
    private boolean overrideAllFiltersEnabled = false;

    public static boolean getRenderingEnabled() {
        return Config.INSTANCE.renderingEnabled;
    }

    public static void setRenderingEnabled(boolean renderingEnabled) {
        Config.INSTANCE.renderingEnabled = renderingEnabled;
        Config.save();
    }

    public static boolean getOverrideAllFiltersEnabled() {
        return Config.INSTANCE.overrideAllFiltersEnabled;
    }

    public static void setOverrideAllFiltersEnabled(boolean overrideAllFiltersEnabled) {
        Config.INSTANCE.overrideAllFiltersEnabled = overrideAllFiltersEnabled;
        Config.save();
    }

    public static void load() {
        try (BufferedReader reader = new BufferedReader(new FileReader(FabricLoader.getInstance().getConfigDir().resolve("healthindicators.json").toFile()));){
            Config config = (Config)GSON.fromJson((Reader)reader, Config.class);
            if (config != null) {
                INSTANCE = config;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(FabricLoader.getInstance().getConfigDir().resolve("healthindicators.json").toFile()));){
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

