/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import draylar.identity.Identity;
import draylar.identity.api.PlayerFavorites;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.api.PlayerUnlocks;
import draylar.identity.api.variant.IdentityType;
import draylar.identity.mixin.accessor.ScreenAccessor;
import draylar.identity.screen.widget.EntityWidget;
import draylar.identity.screen.widget.HelpWidget;
import draylar.identity.screen.widget.PlayerWidget;
import draylar.identity.screen.widget.SearchWidget;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1041;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_746;

public class IdentityScreen
extends class_437 {
    private final List<IdentityType<?>> unlocked = new ArrayList();
    private final Map<IdentityType<?>, class_1309> renderEntities = new LinkedHashMap();
    private final List<EntityWidget> entityWidgets = new ArrayList<EntityWidget>();
    private final SearchWidget searchBar = this.createSearchBar();
    private final PlayerWidget playerButton = this.createPlayerButton();
    private final class_4185 helpButton = this.createHelpButton();
    private String lastSearchContents = "";

    public IdentityScreen() {
        super((class_2561)class_2561.method_43470((String)""));
        super.method_25423(class_310.method_1551(), class_310.method_1551().method_22683().method_4486(), class_310.method_1551().method_22683().method_4502());
        if (this.field_22787.field_1724 == null) {
            this.field_22787.method_1507(null);
            return;
        }
        this.populateRenderEntities();
        this.method_37063((class_364)this.searchBar);
        this.method_37063((class_364)this.playerButton);
        this.method_37063((class_364)this.helpButton);
        this.unlocked.addAll(this.collectUnlockedEntities(this.field_22787.field_1724));
        try {
            this.unlocked.sort((first, second) -> {
                if (PlayerFavorites.has((class_1657)this.field_22787.field_1724, first)) {
                    return -1;
                }
                return 1;
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.populateEntityWidgets(this.field_22787.field_1724, this.unlocked);
        this.searchBar.method_1863(text -> {
            this.method_20086((class_364)this.searchBar);
            if (!this.lastSearchContents.equals(text)) {
                ((ScreenAccessor)((Object)this)).getSelectables().removeIf(button -> button instanceof EntityWidget);
                this.method_25396().removeIf(button -> button instanceof EntityWidget);
                this.entityWidgets.clear();
                List<IdentityType<?>> filtered = this.unlocked.stream().filter(type -> text.isEmpty() || type.getEntityType().method_5882().contains((CharSequence)text)).collect(Collectors.toList());
                this.populateEntityWidgets(this.field_22787.field_1724, filtered);
            }
            this.lastSearchContents = text;
        });
    }

    public void method_37067() {
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        if (this.unlocked.isEmpty()) {
            class_5250 message = class_2561.method_43471((String)"identity.menu_hint");
            float xPosition = (float)this.getWindow().method_4480() / 2.0f - (float)class_310.method_1551().field_1772.method_27525((class_5348)message) / 2.0f;
            float yPosition = (float)this.getWindow().method_4507() / 2.0f;
            context.method_51439(this.field_22787.field_1772, (class_2561)message, (int)xPosition, (int)yPosition, 0xFFFFFF, true);
        }
        this.searchBar.method_25394(context, mouseX, mouseY, delta);
        this.playerButton.method_25394(context, mouseX, mouseY, delta);
        this.helpButton.method_25394(context, mouseX, mouseY, delta);
        this.renderEntityWidgets(context, mouseX, mouseY, delta);
    }

    public void renderEntityWidgets(class_332 context, int mouseX, int mouseY, float delta) {
        double scaledFactor = this.field_22787.method_22683().method_4495();
        int top = 35;
        context.method_51448().method_22903();
        RenderSystem.enableScissor((int)((int)(0.0 * scaledFactor)), (int)((int)(0.0 * scaledFactor)), (int)((int)((double)this.field_22789 * scaledFactor)), (int)((int)((double)(this.field_22790 - top) * scaledFactor)));
        this.entityWidgets.forEach(widget -> widget.method_25394(context, mouseX, mouseY, delta));
        RenderSystem.disableScissor();
        context.method_51448().method_22909();
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.entityWidgets.size() > 0) {
            float firstPos = this.entityWidgets.get(0).method_46427();
            if (amount == 1.0 && firstPos >= 35.0f) {
                return false;
            }
            ((ScreenAccessor)((Object)this)).getSelectables().forEach(button -> {
                if (button instanceof EntityWidget) {
                    EntityWidget widget = (EntityWidget)((Object)button);
                    widget.method_46419((int)((double)widget.method_46427() + amount * 10.0));
                }
            });
        }
        return false;
    }

    private void populateEntityWidgets(class_746 player, List<IdentityType<?>> unlocked) {
        int x = 15;
        int y = 35;
        int rows = (int)Math.ceil((float)unlocked.size() / 7.0f);
        IdentityType<class_1309> currentType = IdentityType.from(PlayerIdentity.getIdentity((class_1657)player));
        for (int yIndex = 0; yIndex <= rows; ++yIndex) {
            for (int xIndex = 0; xIndex < 7; ++xIndex) {
                int listIndex = yIndex * 7 + xIndex;
                if (listIndex >= unlocked.size()) continue;
                IdentityType<?> type = unlocked.get(listIndex);
                boolean isCurrent = false;
                if (currentType != null && currentType.equals(type)) {
                    isCurrent = true;
                }
                EntityWidget<class_1309> entityWidget = new EntityWidget<class_1309>((float)(this.getWindow().method_4486() - 27) / 7.0f * (float)xIndex + (float)x, (float)this.getWindow().method_4502() / 5.0f * (float)yIndex + (float)y, (float)(this.getWindow().method_4486() - 27) / 7.0f, (float)this.getWindow().method_4502() / 5.0f, type, this.renderEntities.get(type), this, PlayerFavorites.has((class_1657)player, type), isCurrent);
                this.method_37063((class_364)entityWidget);
                this.entityWidgets.add(entityWidget);
            }
        }
    }

    private void populateRenderEntities() {
        if (this.renderEntities.isEmpty()) {
            List<IdentityType<?>> types = IdentityType.getAllTypes((class_1937)class_310.method_1551().field_1687);
            for (IdentityType<?> type : types) {
                Object entity = type.create((class_1937)class_310.method_1551().field_1687);
                if (!(entity instanceof class_1309)) continue;
                class_1309 living = (class_1309)entity;
                this.renderEntities.put(type, living);
            }
            Identity.LOGGER.info(String.format("Loaded %d entities for rendering", types.size()));
        }
    }

    private List<IdentityType<?>> collectUnlockedEntities(class_746 player) {
        ArrayList unlocked = new ArrayList();
        this.renderEntities.forEach((type, instance) -> {
            if (PlayerUnlocks.has((class_1657)player, type) || player.method_7337()) {
                unlocked.add((IdentityType<?>)type);
            }
        });
        return unlocked;
    }

    private SearchWidget createSearchBar() {
        return new SearchWidget((float)this.getWindow().method_4486() / 2.0f - (float)this.getWindow().method_4486() / 4.0f / 2.0f - 5.0f, 5.0f, (float)this.getWindow().method_4486() / 4.0f, 20.0f);
    }

    private PlayerWidget createPlayerButton() {
        return new PlayerWidget((float)this.getWindow().method_4486() / 2.0f + (float)this.getWindow().method_4486() / 8.0f + 5.0f, 7.0f, 15.0f, 15.0f, this);
    }

    private class_4185 createHelpButton() {
        return new HelpWidget((int)((float)this.getWindow().method_4486() / 2.0f - (float)this.getWindow().method_4486() / 4.0f / 2.0f - 5.0f) - 30, 5, 20, 20);
    }

    public class_1041 getWindow() {
        return class_310.method_1551().method_22683();
    }

    public void disableAll() {
        this.entityWidgets.forEach(button -> button.setActive(false));
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (mouseY < 35.0) {
            return this.searchBar.method_25402(mouseX, mouseY, button) || this.playerButton.method_25402(mouseX, mouseY, button) || this.helpButton.method_25402(mouseX, mouseY, button);
        }
        return super.method_25402(mouseX, mouseY, button);
    }
}

