/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.mixin;

import draylar.identity.Identity;
import draylar.identity.api.IdentityGranting;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.api.variant.IdentityType;
import draylar.identity.impl.NearbySongAccessor;
import draylar.identity.mixin.accessor.LivingEntityAccessor;
import draylar.identity.registry.IdentityEntityTags;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1420;
import net.minecraft.class_1433;
import net.minecraft.class_1480;
import net.minecraft.class_1628;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements NearbySongAccessor {
    @Unique
    private boolean nearbySongPlaying = false;

    @Shadow
    protected abstract int method_6064(int var1);

    @Shadow
    public abstract boolean method_6059(class_1291 var1);

    protected LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"onDeath"}, at={@At(value="RETURN")})
    private void onDeath(class_1282 source, CallbackInfo ci) {
        class_1297 attacker = source.method_5529();
        @Nullable IdentityType<class_1309> thisType = IdentityType.from((class_1309)this);
        if (attacker instanceof class_1657 && thisType != null) {
            IdentityGranting.grantByAttack((class_1657)attacker, thisType);
        }
    }

    @Redirect(method={"baseTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;setAir(I)V", ordinal=2))
    private void cancelAirIncrement(class_1309 livingEntity, int air) {
        class_1657 player;
        class_1309 identity;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657 && (identity = PlayerIdentity.getIdentity(player = (class_1657)livingEntityMixin)) != null && Identity.isAquatic(identity)) {
            return;
        }
        this.method_5855(this.method_6064(this.method_5669()));
    }

    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;hasStatusEffect(Lnet/minecraft/entity/effect/StatusEffect;)Z", ordinal=0))
    private boolean slowFall(class_1309 livingEntity, class_1291 effect) {
        class_1657 player;
        class_1309 identity;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657 && (identity = PlayerIdentity.getIdentity(player = (class_1657)livingEntityMixin)) != null && !this.method_5715() && identity.method_5864().method_20210(IdentityEntityTags.SLOW_FALLING)) {
            return true;
        }
        return this.method_6059(class_1294.field_5906);
    }

    @ModifyVariable(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;hasStatusEffect(Lnet/minecraft/entity/effect/StatusEffect;)Z", ordinal=1), ordinal=0)
    public float applyWaterCreatureSwimSpeedBoost(float j) {
        class_1657 player;
        class_1309 identity;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657 && (identity = PlayerIdentity.getIdentity(player = (class_1657)livingEntityMixin)) instanceof class_1480) {
            return 0.96f;
        }
        return j;
    }

    @Inject(method={"handleFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleFallDamage(float fallDistance, float damageMultiplier, class_1282 damageSource, CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        class_1309 identity;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657 && (identity = PlayerIdentity.getIdentity(player = (class_1657)livingEntityMixin)) != null) {
            boolean takesFallDamage = identity.method_5747(fallDistance, damageMultiplier, damageSource);
            int damageAmount = ((LivingEntityAccessor)identity).callComputeFallDamage(fallDistance, damageMultiplier);
            if (takesFallDamage && damageAmount > 0) {
                class_1309.class_6823 fallSounds = identity.method_39760();
                this.method_5783(damageAmount > 4 ? fallSounds.comp_302() : fallSounds.comp_301(), 1.0f, 1.0f);
                ((LivingEntityAccessor)identity).callPlayBlockFallSound();
                this.method_5643(this.method_48923().method_48827(), damageAmount);
                cir.setReturnValue((Object)true);
            } else {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"hasStatusEffect"}, at={@At(value="HEAD")}, cancellable=true)
    private void returnHasNightVision(class_1291 effect, CallbackInfoReturnable<Boolean> cir) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657) {
            class_1309 identity;
            class_1657 player = (class_1657)livingEntityMixin;
            if (effect.equals(class_1294.field_5925) && (identity = PlayerIdentity.getIdentity(player)) instanceof class_1420) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"getStatusEffect"}, at={@At(value="HEAD")}, cancellable=true)
    private void returnNightVisionInstance(class_1291 effect, CallbackInfoReturnable<class_1293> cir) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657) {
            class_1309 identity;
            class_1657 player = (class_1657)livingEntityMixin;
            if (effect.equals(class_1294.field_5925) && (identity = PlayerIdentity.getIdentity(player)) instanceof class_1420) {
                cir.setReturnValue((Object)new class_1293(class_1294.field_5925, 100000, 0, false, false));
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getEyeHeight"}, cancellable=true)
    public void getEyeHeight(class_4050 pose, class_4048 dimensions, CallbackInfoReturnable<Float> cir) {
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            try {
                class_1309 identity = PlayerIdentity.getIdentity(player);
                if (identity != null) {
                    cir.setReturnValue((Object)Float.valueOf(((LivingEntityAccessor)identity).callGetEyeHeight(pose, dimensions)));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Inject(method={"hurtByWater"}, at={@At(value="HEAD")}, cancellable=true)
    protected void identity_hurtByWater(CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        class_1309 entity;
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657 && (entity = PlayerIdentity.getIdentity(player = (class_1657)class_13092)) != null) {
            cir.setReturnValue((Object)entity.method_29503());
        }
    }

    @Inject(method={"canBreatheInWater"}, at={@At(value="HEAD")}, cancellable=true)
    protected void identity_canBreatheInWater(CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        class_1309 entity;
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657 && (entity = PlayerIdentity.getIdentity(player = (class_1657)class_13092)) != null) {
            cir.setReturnValue((Object)(entity.method_6094() || entity instanceof class_1433 || entity.method_5864().method_20210(IdentityEntityTags.UNDROWNABLE) ? 1 : 0));
        }
    }

    @Inject(method={"setNearbySongPlaying"}, at={@At(value="RETURN")})
    @Environment(value=EnvType.CLIENT)
    protected void identity_setNearbySongPlaying(class_2338 songPosition, boolean playing, CallbackInfo ci) {
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            this.nearbySongPlaying = playing;
        }
    }

    @Override
    public boolean identity_isNearbySongPlaying() {
        return this.nearbySongPlaying;
    }

    @Inject(method={"isUndead"}, at={@At(value="HEAD")}, cancellable=true)
    protected void identity_isUndead(CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        class_1309 identity;
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657 && (identity = PlayerIdentity.getIdentity(player = (class_1657)class_13092)) != null) {
            cir.setReturnValue((Object)identity.method_5999());
        }
    }

    @Inject(method={"canWalkOnFluid"}, at={@At(value="HEAD")}, cancellable=true)
    protected void identity_canWalkOnFluid(class_3610 state, CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        class_1309 identity;
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657 && (identity = PlayerIdentity.getIdentity(player = (class_1657)class_13092)) != null && identity.method_5864().method_20210(IdentityEntityTags.LAVA_WALKING) && state.method_15767(class_3486.field_15518)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"isClimbing"}, at={@At(value="HEAD")}, cancellable=true)
    protected void identity_allowSpiderClimbing(CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        class_1309 identity;
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657 && (identity = PlayerIdentity.getIdentity(player = (class_1657)class_13092)) instanceof class_1628) {
            cir.setReturnValue((Object)this.field_5976);
        }
    }
}

