/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.init.ModNetwork;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackSettingsMenu;
import com.tiviacz.travelersbackpack.network.IPacket;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class ServerboundSlotPacket
implements IPacket<ServerboundSlotPacket> {
    private final int selectType;
    private final List<?> slotsData;
    public static final int UNSORTABLES = 0;
    public static final int MEMORY = 1;

    public ServerboundSlotPacket(int selectType, List<?> slotsData) {
        this.selectType = selectType;
        this.slotsData = slotsData;
    }

    public static ServerboundSlotPacket decode(class_2540 buffer) {
        int selectType = buffer.readInt();
        List<Object> slotsData = new ArrayList();
        if (selectType == 0) {
            slotsData = buffer.method_34059().intStream().boxed().collect(Collectors.toList());
        }
        if (selectType == 1) {
            slotsData = NbtHelper.deserializeMemorySlotsPacket(buffer.method_10798());
        }
        return new ServerboundSlotPacket(selectType, slotsData);
    }

    @Override
    public void encode(ServerboundSlotPacket message, class_2540 buffer) {
        buffer.writeInt(message.selectType);
        List<Pair<Integer, Boolean>> slotsData = message.slotsData;
        if (message.selectType == 0) {
            List<Pair<Integer, Boolean>> unsortables = slotsData;
            buffer.method_34060((IntList)new IntArrayList(unsortables.stream().mapToInt(Integer::intValue).toArray()));
        }
        if (message.selectType == 1) {
            buffer.method_10794(NbtHelper.serializeMemorySlotsPacket(slotsData));
        }
    }

    @Override
    public class_2960 getPacketId() {
        return ModNetwork.SLOTS_ID;
    }

    public static void handle(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        ServerboundSlotPacket message = ServerboundSlotPacket.decode(buf);
        server.execute(() -> {
            class_1703 patt2683$temp = player.field_7512;
            if (patt2683$temp instanceof BackpackSettingsMenu) {
                BackpackSettingsMenu menu = (BackpackSettingsMenu)patt2683$temp;
                String syncKey = null;
                if (message.selectType == 0) {
                    menu.getWrapper().setUnsortableSlots(message.slotsData);
                    syncKey = "UnsortableSlots";
                }
                if (message.selectType == 1) {
                    List<Pair<Integer, Pair<class_1799, Boolean>>> oldMemoryStacks = menu.getWrapper().getMemorySlots();
                    ArrayList<Pair<Integer, Pair<class_1799, Boolean>>> memoryStacks = new ArrayList<Pair<Integer, Pair<class_1799, Boolean>>>();
                    for (Pair memorizedSlot : message.slotsData) {
                        class_1799 retrievedStack;
                        class_1799 class_17992 = retrievedStack = (Boolean)memorizedSlot.getSecond() != false ? menu.method_7611((Integer)memorizedSlot.getFirst()).method_7677() : menu.method_7611((Integer)memorizedSlot.getFirst()).method_7677().method_7909().method_7854();
                        if (retrievedStack.method_7960()) {
                            for (Pair<Integer, Pair<class_1799, Boolean>> oldMemorizedSlot : oldMemoryStacks) {
                                if (!((Integer)oldMemorizedSlot.getFirst()).equals(memorizedSlot.getFirst())) continue;
                                retrievedStack = (class_1799)((Pair)oldMemorizedSlot.getSecond()).getFirst();
                                break;
                            }
                        }
                        if (retrievedStack.method_7960()) continue;
                        memoryStacks.add((Pair<Integer, Pair<class_1799, Boolean>>)Pair.of((Object)((Integer)memorizedSlot.getFirst()), (Object)Pair.of((Object)retrievedStack, (Object)((Boolean)memorizedSlot.getSecond()))));
                    }
                    menu.getWrapper().setMemorySlots(memoryStacks);
                    syncKey = "MemorySlots";
                }
                if (syncKey != null) {
                    menu.getWrapper().sendDataToClients(syncKey);
                }
            }
        });
    }
}

