/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights;

import dev.lambdaurora.lambdynlights.DynamicLightsConfig;
import dev.lambdaurora.lambdynlights.DynamicLightsMode;
import dev.lambdaurora.lambdynlights.LambDynLightsConstants;
import dev.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import dev.lambdaurora.lambdynlights.api.DynamicLightsContext;
import dev.lambdaurora.lambdynlights.api.DynamicLightsInitializer;
import dev.lambdaurora.lambdynlights.api.behavior.DynamicLightBehavior;
import dev.lambdaurora.lambdynlights.api.behavior.DynamicLightBehaviorManager;
import dev.lambdaurora.lambdynlights.api.entity.EntityLightSourceManager;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSourceManager;
import dev.lambdaurora.lambdynlights.compat.CompatLayer;
import dev.lambdaurora.lambdynlights.engine.DynamicLightBehaviorSources;
import dev.lambdaurora.lambdynlights.engine.DynamicLightingEngine;
import dev.lambdaurora.lambdynlights.engine.source.DeferredDynamicLightSource;
import dev.lambdaurora.lambdynlights.engine.source.DynamicLightSource;
import dev.lambdaurora.lambdynlights.engine.source.EntityDynamicLightSource;
import dev.lambdaurora.lambdynlights.engine.source.EntityDynamicLightSourceBehavior;
import dev.lambdaurora.lambdynlights.mixin.LevelRendererAccessor;
import dev.lambdaurora.lambdynlights.resource.entity.EntityLightSources;
import dev.lambdaurora.lambdynlights.resource.item.ItemLightSources;
import dev.lambdaurora.lambdynlights.util.DynamicLightBehaviorDebugRenderer;
import dev.lambdaurora.lambdynlights.util.DynamicLightDebugRenderer;
import dev.lambdaurora.lambdynlights.util.DynamicLightLevelDebugRenderer;
import dev.yumi.commons.event.EventManager;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.LanguageAdapter;
import net.fabricmc.loader.api.LanguageAdapterException;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_4076;
import net.minecraft.class_638;
import net.minecraft.class_761;
import net.minecraft.class_765;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public class LambDynLights
implements ClientModInitializer,
DynamicLightsContext {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"LambDynamicLights");
    public static final EventManager<class_2960> EVENT_MANAGER = new EventManager((Comparable)LambDynLightsConstants.id("default"), class_2960::method_12829);
    private static LambDynLights INSTANCE;
    public final DynamicLightsConfig config = new DynamicLightsConfig(this);
    private final ItemLightSources itemLightSources = new ItemLightSources();
    private final EntityLightSources entityLightSources = new EntityLightSources(this.itemLightSources);
    private final DynamicLightBehaviorSources dynamicLightBehaviorSources = new DynamicLightBehaviorSources(this);
    public final DynamicLightingEngine engine = new DynamicLightingEngine(this.config);
    private final Set<DynamicLightSource> dynamicLightSources = new HashSet<DynamicLightSource>();
    private final Set<DynamicLightSource> toAdd = new HashSet<DynamicLightSource>();
    private final List<DynamicLightSource> toClear = new ArrayList<DynamicLightSource>();
    private final ReentrantReadWriteLock lightSourcesLock = new ReentrantReadWriteLock();
    public final DynamicLightDebugRenderer.SectionRebuild sectionRebuildDebugRenderer = new DynamicLightDebugRenderer.SectionRebuild(this);
    public final DynamicLightLevelDebugRenderer dynamicLightLevelDebugRenderer = new DynamicLightLevelDebugRenderer(this);
    public final DynamicLightBehaviorDebugRenderer dynamicLightBehaviorDebugRenderer = new DynamicLightBehaviorDebugRenderer(this, this.dynamicLightSources);
    private long lastUpdate = System.currentTimeMillis();
    private boolean shouldTick = false;
    boolean shouldForceRefresh = false;
    private int lastUpdateCount = 0;
    public boolean gameLoadFinished = false;

    public void onInitializeClient() {
        INSTANCE = this;
        LambDynLights.log(LOGGER, "Initializing LambDynamicLights...");
        this.config.load();
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)this.itemLightSources);
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)this.entityLightSources);
        CommonLifecycleEvents.TAGS_LOADED.register((registries, client) -> {
            this.itemLightSources.apply(registries);
            this.entityLightSources.apply(registries);
        });
        ClientTickEvents.START_WORLD_TICK.register(level -> {
            DynamicLightsMode mode = this.config.getDynamicLightsMode();
            boolean shouldTick = mode.isEnabled();
            if (shouldTick && mode.hasDelay()) {
                long currentTime = System.currentTimeMillis();
                if (currentTime < this.lastUpdate + (long)mode.getDelay()) {
                    shouldTick = false;
                } else {
                    this.lastUpdate = currentTime;
                }
            }
            this.shouldTick = shouldTick || this.shouldForceRefresh;
        });
        ClientTickEvents.END_WORLD_TICK.register(level -> {
            class_761 renderer = class_310.method_1551().field_1769;
            this.lightSourcesLock.writeLock().lock();
            if (this.config.getDynamicLightsMode().isEnabled()) {
                level.method_16107().method_15396("dynamic_lighting_compute_spatial_lookup");
                this.engine.computeSpatialLookup(this.dynamicLightSources);
                level.method_16107().method_15407();
            }
            this.toClear.forEach(source -> source.getDynamicLightChunksToRebuild(true).forEach(chunk -> this.scheduleChunkRebuild(renderer, chunk)));
            this.toClear.clear();
            this.lightSourcesLock.writeLock().unlock();
            this.lastUpdateCount = 0;
            if (this.shouldTick) {
                Iterator<DynamicLightSource> it = this.dynamicLightSources.iterator();
                while (it.hasNext()) {
                    DeferredDynamicLightSource deferred;
                    DynamicLightBehavior behavior;
                    DynamicLightSource lightSource = it.next();
                    if (lightSource instanceof DeferredDynamicLightSource && (behavior = (deferred = (DeferredDynamicLightSource)lightSource).behavior()).isRemoved()) {
                        this.toClear.add(lightSource);
                        it.remove();
                        continue;
                    }
                    LongSet chunks = lightSource.getDynamicLightChunksToRebuild(this.shouldForceRefresh || this.toAdd.contains(lightSource));
                    if (chunks.isEmpty()) continue;
                    chunks.forEach(chunk -> this.scheduleChunkRebuild(renderer, chunk));
                    ++this.lastUpdateCount;
                }
                this.toAdd.clear();
            }
            this.sectionRebuildDebugRenderer.tick();
            this.shouldForceRefresh = false;
        });
        this.initializeApi();
        DynamicLightHandlers.registerDefaultHandlers();
    }

    private void initializeApi() {
        this.invokeInitializers("lambdynlights:initializer");
        this.invokeInitializers("dynamiclights");
        FabricLoader.getInstance().getAllMods().stream().filter(mod -> mod.getMetadata().containsCustomValue("lambdynlights:initializer")).forEach(this::invokeInitializer);
    }

    private void invokeInitializers(String entrypointKey) {
        FabricLoader.getInstance().getEntrypointContainers(entrypointKey, DynamicLightsInitializer.class).stream().map(EntrypointContainer::getEntrypoint).forEach(this::invokeInitializer);
    }

    private void invokeInitializer(ModContainer mod) {
        String id = mod.getMetadata().getId();
        CustomValue entrypointValue = mod.getMetadata().getCustomValue("lambdynlights:initializer");
        if (entrypointValue.getType() != CustomValue.CvType.STRING) {
            LambDynLights.error(LOGGER, "Ignoring {} entrypoint from mod {}: not a string", "lambdynlights:initializer", id);
            return;
        }
        try {
            DynamicLightsInitializer initializer = (DynamicLightsInitializer)LanguageAdapter.getDefault().create(mod, entrypointValue.getAsString(), DynamicLightsInitializer.class);
            this.invokeInitializer(initializer);
        }
        catch (LanguageAdapterException e) {
            LambDynLights.error(LOGGER, "Failed to initializer {} entrypoint from mod {}: exception thrown", new Object[]{"lambdynlights:initializer", id, e});
            throw new RuntimeException(e);
        }
    }

    private void invokeInitializer(DynamicLightsInitializer initializer) {
        initializer.onInitializeDynamicLights((DynamicLightsContext)this);
    }

    public ItemLightSourceManager itemLightSourceManager() {
        return this.itemLightSources;
    }

    public EntityLightSourceManager entityLightSourceManager() {
        return this.entityLightSources;
    }

    public DynamicLightBehaviorManager dynamicLightBehaviorManager() {
        return this.dynamicLightBehaviorSources;
    }

    public boolean shouldTick() {
        return this.shouldTick;
    }

    public int getLastUpdateCount() {
        return this.lastUpdateCount;
    }

    public int getLightmapWithDynamicLight(@NotNull class_1920 level, @NotNull class_2338 pos, int lightmap) {
        return this.getLightmapWithDynamicLight(this.getDynamicLightLevel(level, pos), lightmap);
    }

    public int getLightmapWithDynamicLight(double dynamicLightLevel, int lightmap) {
        int blockLevel;
        if (dynamicLightLevel > 0.0 && dynamicLightLevel > (double)(blockLevel = class_765.method_24186((int)lightmap))) {
            int luminance = (int)(dynamicLightLevel * 16.0);
            lightmap &= 0xFFF00000;
            lightmap |= luminance & 0xFFFFF;
        }
        return lightmap;
    }

    public double getDynamicLightLevel(@NotNull class_1920 level, @NotNull class_2338 pos) {
        if (!(level instanceof class_638)) {
            this.lightSourcesLock.readLock().lock();
        }
        double light = this.engine.getDynamicLightLevel(pos);
        if (!(level instanceof class_638)) {
            this.lightSourcesLock.readLock().unlock();
        }
        return light;
    }

    public double getDynamicLightLevel(@NotNull class_2338 pos) {
        return this.engine.getDynamicLightLevel(pos);
    }

    public void addLightSource(@NotNull DynamicLightSource lightSource) {
        if (this.containsLightSource(lightSource)) {
            return;
        }
        this.dynamicLightSources.add(lightSource);
        this.toAdd.add(lightSource);
    }

    public boolean containsLightSource(@NotNull DynamicLightSource lightSource) {
        return this.dynamicLightSources.contains(lightSource);
    }

    public int getLightSourcesCount() {
        return this.dynamicLightSources.size();
    }

    public void removeLightSource(@NotNull EntityDynamicLightSourceBehavior lightSource) {
        Iterator<DynamicLightSource> chunkProviders = this.dynamicLightSources.iterator();
        while (chunkProviders.hasNext()) {
            DynamicLightSource it = chunkProviders.next();
            if (!it.equals(lightSource)) continue;
            chunkProviders.remove();
            this.toClear.add(lightSource);
            break;
        }
    }

    public void clearLightSources() {
        Iterator<DynamicLightSource> chunkProviders = this.dynamicLightSources.iterator();
        while (chunkProviders.hasNext()) {
            EntityDynamicLightSource entityIt;
            DynamicLightSource it = chunkProviders.next();
            chunkProviders.remove();
            if (it instanceof EntityDynamicLightSource && (entityIt = (EntityDynamicLightSource)it).getLuminance() > 0) {
                entityIt.resetDynamicLight();
            }
            this.toClear.add(it);
        }
    }

    public boolean removeLightSources(@NotNull Predicate<DynamicLightSource> filter) {
        boolean result = false;
        Iterator<DynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            EntityDynamicLightSourceBehavior lightSource;
            DynamicLightSource it = dynamicLightSources.next();
            if (!filter.test(it)) continue;
            dynamicLightSources.remove();
            this.toClear.add(it);
            result = true;
            if (!(it instanceof EntityDynamicLightSourceBehavior) || (lightSource = (EntityDynamicLightSourceBehavior)it).getLuminance() <= 0) continue;
            lightSource.resetDynamicLight();
        }
        return result;
    }

    public void removeEntitiesLightSource() {
        this.removeLightSources(lightSource -> lightSource instanceof class_1297 && !(lightSource instanceof class_1657));
    }

    public static void log(Logger logger, String msg) {
        if (!FabricLoader.getInstance().isDevelopmentEnvironment()) {
            msg = "[LambDynLights] " + (String)msg;
        }
        logger.info((String)msg);
    }

    public static void warn(Logger logger, String msg) {
        if (!FabricLoader.getInstance().isDevelopmentEnvironment()) {
            msg = "[LambDynLights] " + (String)msg;
        }
        logger.warn((String)msg);
    }

    public static void warn(Logger logger, String msg, Object ... args) {
        if (!FabricLoader.getInstance().isDevelopmentEnvironment()) {
            msg = "[LambDynLights] " + (String)msg;
        }
        logger.warn((String)msg, args);
    }

    public static void error(Logger logger, String msg, Object ... args) {
        if (!FabricLoader.getInstance().isDevelopmentEnvironment()) {
            msg = "[LambDynLights] " + (String)msg;
        }
        logger.error((String)msg, args);
    }

    private void scheduleChunkRebuild(@NotNull class_761 renderer, long chunkPos) {
        LambDynLights.scheduleChunkRebuild(renderer, class_4076.method_18686((long)chunkPos), class_4076.method_18689((long)chunkPos), class_4076.method_18690((long)chunkPos));
        this.sectionRebuildDebugRenderer.scheduleChunkRebuild(chunkPos);
    }

    public static void scheduleChunkRebuild(@NotNull class_761 renderer, int x, int y, int z) {
        if (class_310.method_1551().field_1687 != null) {
            ((LevelRendererAccessor)renderer).lambdynlights$scheduleChunkRebuild(x, y, z, false);
        }
    }

    public static void updateTracking(@NotNull EntityDynamicLightSourceBehavior lightSource) {
        boolean enabled = lightSource.isDynamicLightEnabled();
        int luminance = lightSource.getLuminance();
        if (!enabled && luminance > 0) {
            lightSource.setDynamicLightEnabled(true);
        } else if (enabled && luminance < 1) {
            lightSource.setDynamicLightEnabled(false);
        }
    }

    private static boolean isEyeSubmergedInFluid(class_1309 entity) {
        if (!((Boolean)LambDynLights.get().config.getWaterSensitiveCheck().get()).booleanValue()) {
            return false;
        }
        class_2338 eyePos = class_2338.method_49637((double)entity.method_23317(), (double)entity.method_23320(), (double)entity.method_23321());
        return !entity.method_37908().method_8316(eyePos).method_15769();
    }

    public static int getLivingEntityLuminanceFromItems(class_1309 entity) {
        int luminance;
        block2: {
            CompatLayer compat;
            boolean submergedInFluid = LambDynLights.isEyeSubmergedInFluid(entity);
            luminance = 0;
            for (class_1799 equipped : entity.method_5743()) {
                if (equipped.method_7960()) continue;
                luminance = Math.max(luminance, LambDynLights.INSTANCE.itemLightSources.getLuminance(equipped, submergedInFluid));
            }
            if (luminance >= 15) break block2;
            Iterator<Object> iterator = CompatLayer.LAYERS.iterator();
            while (iterator.hasNext() && (luminance = Math.max(luminance, (compat = (CompatLayer)iterator.next()).getLivingEntityLuminanceFromItems(LambDynLights.INSTANCE.itemLightSources, entity, submergedInFluid))) != 15) {
            }
        }
        return luminance;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="4.0.0+1.21.4")
    public static int getLuminanceFromItemStack(@NotNull class_1799 stack, boolean submergedInWater) {
        return LambDynLights.INSTANCE.itemLightSources.getLuminance(stack, submergedInWater);
    }

    public static <T extends class_1297> int getLuminanceFrom(T entity) {
        if (!((Boolean)LambDynLights.INSTANCE.config.getEntitiesLightSource().get()).booleanValue()) {
            return 0;
        }
        if (entity == class_310.method_1551().field_1724 && !((Boolean)LambDynLights.INSTANCE.config.getSelfLightSource().get()).booleanValue()) {
            return 0;
        }
        if (!DynamicLightingEngine.canLightUp(entity)) {
            return 0;
        }
        return LambDynLights.INSTANCE.entityLightSources.getLuminance(entity);
    }

    public static LambDynLights get() {
        return INSTANCE;
    }
}

