/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.cms.jcajce;

import am_libs.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import am_libs.org.bouncycastle.cms.CMSException;
import am_libs.org.bouncycastle.cms.RecipientOperator;
import am_libs.org.bouncycastle.cms.jcajce.JcePasswordRecipient;
import am_libs.org.bouncycastle.jcajce.io.MacOutputStream;
import am_libs.org.bouncycastle.operator.GenericKey;
import am_libs.org.bouncycastle.operator.MacCalculator;
import am_libs.org.bouncycastle.operator.jcajce.JceGenericKey;
import java.io.OutputStream;
import java.security.Key;
import javax.crypto.Mac;

public class JcePasswordAuthenticatedRecipient
extends JcePasswordRecipient {
    public JcePasswordAuthenticatedRecipient(char[] cArray) {
        super(cArray);
    }

    @Override
    public RecipientOperator getRecipientOperator(AlgorithmIdentifier algorithmIdentifier, final AlgorithmIdentifier algorithmIdentifier2, byte[] byArray, byte[] byArray2) throws CMSException {
        final Key key = this.extractSecretKey(algorithmIdentifier, algorithmIdentifier2, byArray, byArray2);
        final Mac mac = this.helper.createContentMac(key, algorithmIdentifier2);
        return new RecipientOperator(new MacCalculator(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algorithmIdentifier2;
            }

            @Override
            public GenericKey getKey() {
                return new JceGenericKey(algorithmIdentifier2, key);
            }

            @Override
            public OutputStream getOutputStream() {
                return new MacOutputStream(mac);
            }

            @Override
            public byte[] getMac() {
                return mac.doFinal();
            }
        });
    }
}

