/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.cms;

import am_libs.org.bouncycastle.asn1.ASN1EncodableVector;
import am_libs.org.bouncycastle.asn1.ASN1Set;
import am_libs.org.bouncycastle.asn1.DEROctetString;
import am_libs.org.bouncycastle.asn1.DERSet;
import am_libs.org.bouncycastle.asn1.cms.AuthEnvelopedData;
import am_libs.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import am_libs.org.bouncycastle.asn1.cms.ContentInfo;
import am_libs.org.bouncycastle.asn1.cms.EncryptedContentInfo;
import am_libs.org.bouncycastle.cms.CMSAuthEnvelopedData;
import am_libs.org.bouncycastle.cms.CMSAuthEnvelopedGenerator;
import am_libs.org.bouncycastle.cms.CMSException;
import am_libs.org.bouncycastle.cms.CMSTypedData;
import am_libs.org.bouncycastle.cms.CMSUtils;
import am_libs.org.bouncycastle.operator.OutputAEADEncryptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CMSAuthEnvelopedDataGenerator
extends CMSAuthEnvelopedGenerator {
    private CMSAuthEnvelopedData doGenerate(CMSTypedData cMSTypedData, OutputAEADEncryptor outputAEADEncryptor) throws CMSException {
        ASN1Set aSN1Set;
        Object object;
        ASN1EncodableVector aSN1EncodableVector = CMSUtils.getRecipentInfos(outputAEADEncryptor.getKey(), this.recipientInfoGenerators);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object = outputAEADEncryptor.getOutputStream(byteArrayOutputStream);
            cMSTypedData.write((OutputStream)object);
            aSN1Set = CMSUtils.processAuthAttrSet(this.authAttrsGenerator, outputAEADEncryptor);
            ((OutputStream)object).close();
        }
        catch (IOException iOException) {
            throw new CMSException("unable to process authenticated content: " + iOException.getMessage(), iOException);
        }
        object = byteArrayOutputStream.toByteArray();
        byte[] byArray = outputAEADEncryptor.getMAC();
        EncryptedContentInfo encryptedContentInfo = CMSUtils.getEncryptedContentInfo(cMSTypedData, outputAEADEncryptor, (byte[])object);
        ASN1Set aSN1Set2 = CMSUtils.getAttrDLSet(this.unauthAttrsGenerator);
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.authEnvelopedData, new AuthEnvelopedData(this.originatorInfo, new DERSet(aSN1EncodableVector), encryptedContentInfo, aSN1Set, new DEROctetString(byArray), aSN1Set2));
        return new CMSAuthEnvelopedData(contentInfo);
    }

    public CMSAuthEnvelopedData generate(CMSTypedData cMSTypedData, OutputAEADEncryptor outputAEADEncryptor) throws CMSException {
        return this.doGenerate(cMSTypedData, outputAEADEncryptor);
    }
}

