/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.catalogue.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.catalogue.Constants;
import com.mrcrayfish.catalogue.client.ClientHelper;
import com.mrcrayfish.catalogue.client.IModData;
import com.mrcrayfish.catalogue.client.screen.widget.CatalogueCheckBoxButton;
import com.mrcrayfish.catalogue.client.screen.widget.CatalogueIconButton;
import com.mrcrayfish.catalogue.platform.ClientServices;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1060;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import net.minecraft.class_757;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;

public class CatalogueModListScreen
extends class_437 {
    private static final Comparator<ModListEntry> SORT = Comparator.comparing(o -> o.getData().getDisplayName());
    private static final class_2960 MISSING_BANNER = new class_2960("catalogue", "textures/gui/missing_banner.png");
    private static final class_2960 VERSION_CHECK_ICONS = new class_2960("forge", "textures/gui/version_check_icons.png");
    private static final Map<String, Pair<class_2960, Dimension>> BANNER_CACHE = new HashMap<String, Pair<class_2960, Dimension>>();
    private static final Map<String, Pair<class_2960, Dimension>> IMAGE_ICON_CACHE = new HashMap<String, Pair<class_2960, Dimension>>();
    private static final Map<String, class_1792> ITEM_ICON_CACHE = new HashMap<String, class_1792>();
    private static final Map<String, IModData> CACHED_MODS = new HashMap<String, IModData>();
    private static class_2960 cachedBackground;
    private static boolean loaded;
    private final class_437 parentScreen;
    private class_342 searchTextField;
    private ModList modList;
    private IModData selectedModData;
    private class_4185 modFolderButton;
    private class_4185 configButton;
    private class_4185 websiteButton;
    private class_4185 issueButton;
    private class_4286 updatesButton;
    private StringList descriptionList;
    private int tooltipYOffset;
    private List<? extends class_5481> activeTooltip;

    public CatalogueModListScreen(class_437 parent) {
        super(class_5244.field_39003);
        this.parentScreen = parent;
        if (!loaded) {
            ClientServices.PLATFORM.getAllModData().forEach(data -> CACHED_MODS.put(data.getModId(), (IModData)data));
            loaded = true;
        }
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parentScreen);
    }

    protected void method_25426() {
        super.method_25426();
        this.searchTextField = new class_342(this.field_22793, 11, 25, 148, 20, class_5244.field_39003);
        this.searchTextField.method_1863(s -> {
            this.updateSearchField((String)s);
            this.modList.filterAndUpdateList((String)s);
            this.updateSelectedModList();
        });
        this.method_25429((class_364)this.searchTextField);
        this.modList = new ModList();
        this.modList.method_25333(10);
        this.modList.method_31323(false);
        this.method_25429((class_364)this.modList);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24339, btn -> this.field_22787.method_1507(null)).method_46433(10, this.modList.getBottom() + 8).method_46437(127, 20).method_46431());
        this.modFolderButton = (class_4185)this.method_37063((class_364)new CatalogueIconButton(140, this.modList.getBottom() + 8, 0, 0, onPress -> class_156.method_668().method_672(ClientServices.PLATFORM.getModDirectory())));
        int padding = 10;
        int contentLeft = this.modList.getRight() + 12 + padding;
        int contentWidth = this.field_22789 - contentLeft - padding;
        int buttonWidth = (contentWidth - padding) / 3;
        this.configButton = (class_4185)this.method_37063((class_364)new CatalogueIconButton(contentLeft, 105, 10, 0, buttonWidth, (class_2561)class_2561.method_43471((String)"catalogue.gui.config"), onPress -> {
            if (this.selectedModData != null) {
                this.selectedModData.openConfigScreen(this);
            }
        }));
        this.configButton.field_22764 = false;
        this.websiteButton = (class_4185)this.method_37063((class_364)new CatalogueIconButton(contentLeft + buttonWidth + 5, 105, 20, 0, buttonWidth, (class_2561)class_2561.method_43470((String)"Website"), onPress -> this.openLink(this.selectedModData.getHomepage())));
        this.websiteButton.field_22764 = false;
        this.issueButton = (class_4185)this.method_37063((class_364)new CatalogueIconButton(contentLeft + buttonWidth + buttonWidth + 10, 105, 30, 0, buttonWidth, (class_2561)class_2561.method_43470((String)"Submit Bug"), onPress -> this.openLink(this.selectedModData.getIssueTracker())));
        this.issueButton.field_22764 = false;
        this.descriptionList = new StringList(contentWidth, this.field_22790 - 135 - 55, contentLeft, 130);
        this.descriptionList.method_31323(false);
        this.descriptionList.method_31322(false);
        this.method_25429((class_364)this.descriptionList);
        this.updatesButton = (class_4286)this.method_37063((class_364)new CatalogueCheckBoxButton(this.modList.getRight() - 14, 7, button -> {
            this.modList.filterAndUpdateList(this.searchTextField.method_1882());
            this.updateSelectedModList();
        }));
        this.modList.filterAndUpdateList(this.searchTextField.method_1882());
        if (this.selectedModData != null) {
            this.setSelectedModData(this.selectedModData);
            this.updateSelectedModList();
            ModListEntry entry = this.modList.getEntryFromInfo(this.selectedModData);
            if (entry != null) {
                this.modList.centerScrollOn(entry);
            }
        }
        this.updateSearchField(this.searchTextField.method_1882());
    }

    private void openLink(@Nullable String url) {
        if (url != null) {
            class_2583 style = class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11749, url));
            this.method_25430(style);
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.activeTooltip = null;
        this.method_25420(graphics);
        this.drawModList(graphics, mouseX, mouseY, partialTicks);
        this.drawModInfo(graphics, mouseX, mouseY, partialTicks);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        Optional<IModData> optional = Optional.ofNullable(CACHED_MODS.get("catalogue"));
        optional.ifPresent(this::loadAndCacheLogo);
        Pair<class_2960, Dimension> pair = BANNER_CACHE.get("catalogue");
        if (pair != null && pair.getLeft() != null) {
            class_2960 textureId = (class_2960)pair.getLeft();
            Dimension size = (Dimension)pair.getRight();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.method_25293(textureId, 10, 9, 10, 10, 0.0f, 0.0f, size.width, size.height, size.width, size.height);
        }
        if (ClientHelper.isMouseWithin(10, 9, 10, 10, mouseX, mouseY)) {
            this.setActiveTooltip((class_2561)class_2561.method_43471((String)"catalogue.gui.info"));
            this.tooltipYOffset = 10;
        }
        if (this.modFolderButton.method_25405((double)mouseX, (double)mouseY)) {
            this.setActiveTooltip((class_2561)class_2561.method_43471((String)"catalogue.gui.open_mods_folder"));
        }
        if (this.activeTooltip != null) {
            graphics.method_51447(this.field_22793, this.activeTooltip, mouseX, mouseY + this.tooltipYOffset);
            this.tooltipYOffset = 0;
        }
    }

    private void updateSelectedModList() {
        ModListEntry selectedEntry = this.modList.getEntryFromInfo(this.selectedModData);
        if (selectedEntry != null) {
            this.modList.method_25313((class_350.class_351)selectedEntry);
        }
    }

    private void updateSearchField(String value) {
        if (value.isEmpty()) {
            this.searchTextField.method_1887(class_2561.method_43471((String)"catalogue.gui.search").method_10852((class_2561)class_2561.method_43470((String)"...")).getString());
        } else {
            Optional<IModData> optional = CACHED_MODS.values().stream().filter(data -> data.getDisplayName().toLowerCase(Locale.ENGLISH).startsWith(value.toLowerCase(Locale.ENGLISH))).min(Comparator.comparing(IModData::getDisplayName));
            if (optional.isPresent()) {
                int length = value.length();
                String displayName = optional.get().getDisplayName();
                this.searchTextField.method_1887(displayName.substring(length));
            } else {
                this.searchTextField.method_1887("");
            }
        }
    }

    private void drawModList(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (ClientServices.PLATFORM.isForge()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.method_25290(VERSION_CHECK_ICONS, this.modList.getRight() - 24, 10, 24.0f, 0.0f, 8, 8, 64, 16);
        }
        this.modList.method_25394(graphics, mouseX, mouseY, partialTicks);
        graphics.method_27535(this.field_22793, (class_2561)ClientServices.COMPONENT.createTitle().method_27692(class_124.field_1067).method_27692(class_124.field_1068), 70, 10, 0xFFFFFF);
        this.searchTextField.method_25394(graphics, mouseX, mouseY, partialTicks);
        if (ClientHelper.isMouseWithin(this.modList.getRight() - 14, 7, 14, 14, mouseX, mouseY)) {
            this.setActiveTooltip(ClientServices.COMPONENT.createFilterUpdates());
            this.tooltipYOffset = 10;
        }
    }

    private void drawModInfo(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int listRight = this.modList.getRight();
        graphics.method_25301(listRight + 11, -1, this.field_22790, -9408400);
        graphics.method_25294(listRight + 12, 0, this.field_22789, this.field_22790, 0x66000000);
        this.descriptionList.method_25394(graphics, mouseX, mouseY, partialTicks);
        int contentLeft = listRight + 12 + 10;
        int contentWidth = this.field_22789 - contentLeft - 10;
        if (this.selectedModData != null) {
            String authors;
            this.drawBackground(graphics, this.field_22789 - contentLeft + 10, listRight + 12, 0);
            this.drawBanner(graphics, contentWidth, contentLeft, 10, this.field_22789 - (listRight + 12 + 10) - 10, 50);
            class_4587 poseStack = graphics.method_51448();
            poseStack.method_22903();
            poseStack.method_46416((float)contentLeft, 70.0f, 0.0f);
            poseStack.method_22905(2.0f, 2.0f, 2.0f);
            graphics.method_25303(this.field_22793, this.selectedModData.getDisplayName(), 0, 0, 0xFFFFFF);
            poseStack.method_22909();
            class_5250 modId = class_2561.method_43470((String)("Mod ID: " + this.selectedModData.getModId())).method_27692(class_124.field_1063);
            int modIdWidth = this.field_22793.method_27525((class_5348)modId);
            graphics.method_27535(this.field_22793, (class_2561)modId, contentLeft + contentWidth - modIdWidth, 92, 0xFFFFFF);
            this.drawStringWithLabel(graphics, "catalogue.gui.version", this.selectedModData.getVersion().toString(), contentLeft, 92, contentWidth, mouseX, mouseY, class_124.field_1080, class_124.field_1068);
            IModData.Update update = this.selectedModData.getUpdate();
            if (ClientServices.PLATFORM.isForge() && update != null && update.url() != null && !update.url().isBlank()) {
                class_5250 version = ClientServices.COMPONENT.createVersion(this.selectedModData.getVersion());
                int versionWidth = this.field_22793.method_27525((class_5348)version);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int vOffset = update.animated() && (System.currentTimeMillis() / 800L & 1L) == 1L ? 8 : 0;
                graphics.method_25290(VERSION_CHECK_ICONS, contentLeft + versionWidth + 5, 92, (float)(update.texOffset() * 8), (float)vOffset, 8, 8, 64, 16);
                if (ClientHelper.isMouseWithin(contentLeft + versionWidth + 5, 92, 8, 8, mouseX, mouseY)) {
                    class_5250 message = ClientServices.COMPONENT.createFormatted("catalogue.gui.update_available", update.url());
                    this.setActiveTooltip((class_2561)message);
                }
            }
            int labelOffset = this.field_22790 - 20;
            String license = this.selectedModData.getLicense();
            this.drawStringWithLabel(graphics, "catalogue.gui.licenses", license, contentLeft, labelOffset, contentWidth, mouseX, mouseY, class_124.field_1080, class_124.field_1068);
            labelOffset -= 15;
            String credits = this.selectedModData.getCredits();
            if (credits != null) {
                this.drawStringWithLabel(graphics, ClientServices.COMPONENT.getCreditsKey(), credits, contentLeft, labelOffset, contentWidth, mouseX, mouseY, class_124.field_1080, class_124.field_1068);
                labelOffset -= 15;
            }
            if ((authors = this.selectedModData.getAuthors()) != null) {
                this.drawStringWithLabel(graphics, "catalogue.gui.authors", authors, contentLeft, labelOffset, contentWidth, mouseX, mouseY, class_124.field_1080, class_124.field_1068);
            }
        } else {
            class_5250 message = class_2561.method_43471((String)"catalogue.gui.no_selection").method_27692(class_124.field_1080);
            graphics.method_27534(this.field_22793, (class_2561)message, contentLeft + contentWidth / 2, this.field_22790 / 2 - 5, 0xFFFFFF);
        }
    }

    private void drawStringWithLabel(class_332 graphics, String format, String text, int x, int y, int maxWidth, int mouseX, int mouseY, class_124 labelColor, class_124 contentColor) {
        class_5250 formatted = ClientServices.COMPONENT.createFormatted(format, text);
        String rawString = formatted.getString();
        String label = rawString.substring(0, rawString.indexOf(":") + 1);
        Object content = rawString.substring(rawString.indexOf(":") + 1);
        if (this.field_22793.method_27525((class_5348)formatted) > maxWidth) {
            content = this.field_22793.method_27523((String)content, maxWidth - this.field_22793.method_1727(label) - 7) + "...";
            class_5250 credits = class_2561.method_43470((String)label).method_27692(labelColor);
            credits.method_10852((class_2561)class_2561.method_43470((String)content).method_27692(contentColor));
            graphics.method_27535(this.field_22793, (class_2561)credits, x, y, 0xFFFFFF);
            if (ClientHelper.isMouseWithin(x, y, maxWidth, 9, mouseX, mouseY)) {
                this.setActiveTooltip((class_2561)class_2561.method_43470((String)text));
            }
        } else {
            graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)label).method_27692(labelColor).method_10852((class_2561)class_2561.method_43470((String)content).method_27692(contentColor)), x, y, 0xFFFFFF);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        IModData.Update update;
        class_5250 version;
        int versionWidth;
        int contentLeft;
        if (ClientHelper.isMouseWithin(10, 9, 10, 10, (int)mouseX, (int)mouseY) && button == 0) {
            this.openLink("https://www.curseforge.com/minecraft/mc-mods/catalogue");
            return true;
        }
        if (ClientServices.PLATFORM.isForge() && this.selectedModData != null && ClientHelper.isMouseWithin((contentLeft = this.modList.getRight() + 12 + 10) + (versionWidth = this.field_22793.method_27525((class_5348)(version = ClientServices.COMPONENT.createVersion(this.selectedModData.getVersion())))) + 5, 92, 8, 8, (int)mouseX, (int)mouseY) && (update = this.selectedModData.getUpdate()) != null && update.url() != null && !update.url().isBlank()) {
            class_2583 style = class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11749, update.url()));
            this.method_25430(style);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void setActiveTooltip(class_2561 content) {
        this.activeTooltip = this.field_22793.method_1728((class_5348)content, Math.min(200, this.field_22789));
        this.tooltipYOffset = 0;
    }

    private void setSelectedModData(IModData data) {
        this.selectedModData = data;
        this.loadAndCacheLogo(data);
        this.loadAndCacheBackground(data);
        this.configButton.field_22764 = true;
        this.websiteButton.field_22764 = true;
        this.issueButton.field_22764 = true;
        this.configButton.field_22763 = data.hasConfig();
        this.websiteButton.field_22763 = data.getHomepage() != null;
        this.issueButton.field_22763 = data.getIssueTracker() != null;
        int contentLeft = this.modList.getRight() + 12 + 10;
        int contentWidth = this.field_22789 - contentLeft - 10;
        int labelCount = this.getLabelCount(data);
        this.descriptionList.method_25323(contentWidth, this.field_22790 - 135 - 10 - labelCount * 15, 130, this.field_22790 - 10 - labelCount * 15);
        this.descriptionList.method_25333(contentLeft);
        this.descriptionList.setTextFromInfo(data);
        this.descriptionList.method_25307(0.0);
    }

    private int getLabelCount(IModData selectedModData) {
        int count = 1;
        if (selectedModData.getCredits() != null && !selectedModData.getCredits().isBlank()) {
            ++count;
        }
        if (selectedModData.getAuthors() != null && !selectedModData.getAuthors().isBlank()) {
            ++count;
        }
        return count;
    }

    private void drawBackground(class_332 graphics, int contentWidth, int x, int y) {
        if (this.selectedModData == null) {
            return;
        }
        if (cachedBackground == null) {
            return;
        }
        RenderSystem.setShader(class_757::method_34541);
        RenderSystem.setShaderTexture((int)0, (class_2960)cachedBackground);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
        builder.method_22918(matrix, (float)x, (float)y, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(0.0f, 0.0f).method_1344();
        builder.method_22918(matrix, (float)x, (float)(y + 128), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 0.0f).method_22913(0.0f, 1.0f).method_1344();
        builder.method_22918(matrix, (float)(x + contentWidth), (float)(y + 128), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 0.0f).method_22913(1.0f, 1.0f).method_1344();
        builder.method_22918(matrix, (float)(x + contentWidth), (float)y, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(1.0f, 0.0f).method_1344();
        class_286.method_43433((class_287.class_7433)builder.method_1326());
        RenderSystem.disableBlend();
    }

    private void drawBanner(class_332 graphics, int contentWidth, int x, int y, int maxWidth, int maxHeight) {
        if (this.selectedModData != null) {
            Pair<class_2960, Dimension> logoInfo;
            class_2960 logoResource = MISSING_BANNER;
            Dimension size = new Dimension(600, 120);
            if (BANNER_CACHE.containsKey(this.selectedModData.getModId()) && (logoInfo = BANNER_CACHE.get(this.selectedModData.getModId())).getLeft() != null) {
                logoResource = (class_2960)logoInfo.getLeft();
                size = (Dimension)logoInfo.getRight();
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            int width = size.width;
            int height = size.height;
            if (size.width > maxWidth) {
                width = maxWidth;
                height = width * size.height / size.width;
            }
            if (height > maxHeight) {
                height = maxHeight;
                width = height * size.width / size.height;
            }
            graphics.method_25293(logoResource, x += (contentWidth - width) / 2, y += (maxHeight - height) / 2, width, height, 0.0f, 0.0f, size.width, size.height, size.width, size.height);
            RenderSystem.disableBlend();
        }
    }

    private void loadAndCacheLogo(IModData data) {
        if (BANNER_CACHE.containsKey(data.getModId())) {
            return;
        }
        BANNER_CACHE.put(data.getModId(), (Pair<class_2960, Dimension>)Pair.of(null, (Object)new Dimension(0, 0)));
        String banner = data.getBanner();
        if (banner != null && !banner.isEmpty()) {
            if (ClientServices.PLATFORM.isForge() && (banner.contains("/") || banner.contains("\\"))) {
                Constants.LOG.warn("Skipped loading logo file from {}. The file name '{}' contained illegal characters '/' or '\\'", (Object)data.getDisplayName(), (Object)banner);
                return;
            }
            ClientServices.PLATFORM.loadNativeImage(data.getModId(), banner, image -> {
                if (image.method_4307() > 1200 || image.method_4323() > 240) {
                    Constants.LOG.warn("Failed to load banner image for {} as it exceeds the maximum size of 1200x240px", (Object)data.getModId());
                    return;
                }
                class_1060 textureManager = this.field_22787.method_1531();
                BANNER_CACHE.put(data.getModId(), (Pair<class_2960, Dimension>)Pair.of((Object)textureManager.method_4617("modlogo", this.createLogoTexture((class_1011)image, data.isLogoSmooth())), (Object)new Dimension(image.method_4307(), image.method_4323())));
            });
        }
    }

    private void loadAndCacheIcon(IModData data) {
        if (IMAGE_ICON_CACHE.containsKey(data.getModId())) {
            return;
        }
        IMAGE_ICON_CACHE.put(data.getModId(), (Pair<class_2960, Dimension>)Pair.of(null, (Object)new Dimension(0, 0)));
        String imageIcon = data.getImageIcon();
        if (imageIcon != null && !imageIcon.isEmpty()) {
            if (ClientServices.PLATFORM.isForge() && (imageIcon.contains("/") || imageIcon.contains("\\"))) {
                Constants.LOG.warn("Skipped loading Catalogue icon file from {}. The file name '{}' contained illegal characters '/' or '\\'", (Object)data.getDisplayName(), (Object)imageIcon);
                return;
            }
            ClientServices.PLATFORM.loadNativeImage(data.getModId(), imageIcon, image -> {
                class_1060 textureManager = this.field_22787.method_1531();
                IMAGE_ICON_CACHE.put(data.getModId(), (Pair<class_2960, Dimension>)Pair.of((Object)textureManager.method_4617("catalogueicon", this.createLogoTexture((class_1011)image, false)), (Object)new Dimension(image.method_4307(), image.method_4323())));
            });
            return;
        }
        String logoFile = data.getBanner();
        if (logoFile != null && !logoFile.isEmpty()) {
            if (ClientServices.PLATFORM.isForge() && (logoFile.contains("/") || logoFile.contains("\\"))) {
                Constants.LOG.warn("Skipped loading logo file from {}. The file name '{}' contained illegal characters '/' or '\\'", (Object)data.getDisplayName(), (Object)imageIcon);
                return;
            }
            ClientServices.PLATFORM.loadNativeImage(data.getModId(), imageIcon, image -> {
                if (image.method_4307() == image.method_4323()) {
                    class_1060 textureManager = this.field_22787.method_1531();
                    String modId = data.getModId();
                    if (BANNER_CACHE.containsKey(modId) && BANNER_CACHE.get(modId).getLeft() != null) {
                        IMAGE_ICON_CACHE.put(modId, BANNER_CACHE.get(modId));
                        return;
                    }
                    class_1043 texture = this.createLogoTexture((class_1011)image, data.isLogoSmooth());
                    Dimension size = new Dimension(image.method_4307(), image.method_4323());
                    class_2960 textureId = textureManager.method_4617("catalogueicon", texture);
                    IMAGE_ICON_CACHE.put(modId, (Pair<class_2960, Dimension>)Pair.of((Object)textureId, (Object)size));
                    BANNER_CACHE.put(modId, (Pair<class_2960, Dimension>)Pair.of((Object)textureId, (Object)size));
                }
            });
        }
    }

    private void loadAndCacheBackground(IModData data) {
        if (cachedBackground != null) {
            class_1060 textureManager = this.field_22787.method_1531();
            textureManager.method_4615(cachedBackground);
        }
        cachedBackground = null;
        String background = data.getBackground();
        if (background != null && !background.isEmpty()) {
            if (ClientServices.PLATFORM.isForge() && (background.contains("/") || background.contains("\\"))) {
                Constants.LOG.warn("Skipped loading Catalogue background file from {}. The file name '{}' contained illegal characters '/' or '\\'", (Object)data.getDisplayName(), (Object)background);
                return;
            }
            ClientServices.PLATFORM.loadNativeImage(data.getModId(), background, image -> {
                if (image.method_4307() != 512 || image.method_4323() != 256) {
                    return;
                }
                class_1060 textureManager = this.field_22787.method_1531();
                cachedBackground = textureManager.method_4617("cataloguebackground", this.createLogoTexture((class_1011)image, false));
            });
        }
    }

    private class_1043 createLogoTexture(final class_1011 image, final boolean smooth) {
        return new class_1043(image){

            public void method_4524() {
                this.method_23207();
                image.method_22619(0, 0, 0, 0, 0, image.method_4307(), image.method_4323(), smooth, false, false, false);
            }
        };
    }

    static {
        loaded = false;
    }

    private class ModList
    extends class_4280<ModListEntry> {
        public ModList() {
            super(CatalogueModListScreen.this.field_22787, 150, CatalogueModListScreen.this.field_22790, 46, CatalogueModListScreen.this.field_22790 - 35, 26);
        }

        protected int method_25329() {
            return this.field_19088 + this.field_22742 - 6;
        }

        public int method_25342() {
            return this.field_19088;
        }

        public int method_25322() {
            return this.field_22742;
        }

        public void filterAndUpdateList(String text) {
            Predicate<IModData> filter = ClientServices.PLATFORM.isForge() ? data -> !CatalogueModListScreen.this.updatesButton.method_20372() || data.getUpdate() != null : data -> data.getType() == IModData.Type.DEFAULT || data.getModId().equals("minecraft") || data.getModId().equals("fabric-api") || CatalogueModListScreen.this.updatesButton.method_20372();
            List entries = CACHED_MODS.values().stream().filter(info -> info.getDisplayName().toLowerCase(Locale.ENGLISH).contains(text.toLowerCase(Locale.ENGLISH))).filter(filter).map(info -> new ModListEntry((IModData)info, this)).sorted(SORT).collect(Collectors.toList());
            this.method_25314(entries);
            this.method_25307(0.0);
        }

        @Nullable
        public ModListEntry getEntryFromInfo(IModData data) {
            return this.method_25396().stream().filter(entry -> entry.data == data).findFirst().orElse(null);
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            graphics.method_44379(this.method_25342(), this.getTop(), this.method_25342() + this.getWidth(), this.getBottom());
            super.method_25394(graphics, mouseX, mouseY, partialTicks);
            graphics.method_44380();
        }

        public boolean method_25404(int key, int scanCode, int modifiers) {
            if (key == 257 && this.method_25334() != null) {
                CatalogueModListScreen.this.setSelectedModData(((ModListEntry)this.method_25334()).data);
                class_1144 handler = class_310.method_1551().method_1483();
                handler.method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                return true;
            }
            return super.method_25404(key, scanCode, modifiers);
        }

        public void method_37020(class_6382 p_169152_) {
        }

        public void centerScrollOn(ModListEntry entry) {
            super.method_25324((class_350.class_351)entry);
        }

        public int getLeft() {
            return this.field_19088;
        }

        public int getRight() {
            return this.field_19087;
        }

        public int getTop() {
            return this.field_19085;
        }

        public int getBottom() {
            return this.field_19086;
        }

        public int getWidth() {
            return this.field_22742;
        }
    }

    private class StringList
    extends class_350<StringEntry> {
        public StringList(int width, int height, int left, int top) {
            super(CatalogueModListScreen.this.field_22787, width, CatalogueModListScreen.this.field_22790, top, top + height, 10);
            this.method_25333(left);
        }

        public void setTextFromInfo(IModData data) {
            this.method_25339();
            CatalogueModListScreen.this.field_22793.method_27527().method_27498(data.getDescription().trim(), this.method_25322(), class_2583.field_24360).forEach(text -> this.method_25321((class_350.class_351)new StringEntry(text.getString().replace("\n", "").replace("\r", "").trim())));
        }

        public void setSelected(@Nullable StringEntry entry) {
        }

        protected int method_25329() {
            return this.field_19088 + this.field_22742 - 7;
        }

        public int method_25342() {
            return this.field_19088;
        }

        public int method_25322() {
            return this.field_22742 - 10;
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            graphics.method_44379(this.field_19088, this.field_19085, this.field_19088 + this.field_22742, this.field_19086);
            super.method_25394(graphics, mouseX, mouseY, partialTicks);
            graphics.method_44380();
        }

        public void method_37020(class_6382 output) {
        }
    }

    private class ModListEntry
    extends class_4280.class_4281<ModListEntry> {
        private final IModData data;
        private final ModList list;
        private final class_1799 icon;

        public ModListEntry(IModData data, ModList list) {
            this.data = data;
            this.list = list;
            this.icon = new class_1799((class_1935)this.getItemIcon());
        }

        public void method_25343(class_332 graphics, int index, int top, int left, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            graphics.method_27535(CatalogueModListScreen.this.field_22793, this.getFormattedModName(), left + 24, top + 2, 0xFFFFFF);
            graphics.method_27535(CatalogueModListScreen.this.field_22793, (class_2561)class_2561.method_43470((String)this.data.getVersion().toString()).method_27692(class_124.field_1080), left + 24, top + 12, 0xFFFFFF);
            CatalogueModListScreen.this.loadAndCacheIcon(this.data);
            if (IMAGE_ICON_CACHE.containsKey(this.data.getModId()) && IMAGE_ICON_CACHE.get(this.data.getModId()).getLeft() != null) {
                class_2960 logoResource = class_1060.field_5285;
                Dimension size = new Dimension(16, 16);
                Pair<class_2960, Dimension> logoInfo = IMAGE_ICON_CACHE.get(this.data.getModId());
                if (logoInfo != null && logoInfo.getLeft() != null) {
                    logoResource = (class_2960)logoInfo.getLeft();
                    size = (Dimension)logoInfo.getRight();
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.enableBlend();
                graphics.method_25293(logoResource, left + 4, top + 2, 16, 16, 0.0f, 0.0f, size.width, size.height, size.width, size.height);
                RenderSystem.disableBlend();
            } else {
                try {
                    graphics.method_51427(this.icon, left + 4, top + 2);
                }
                catch (Exception e) {
                    ITEM_ICON_CACHE.put(this.data.getModId(), class_1802.field_8270);
                }
            }
            IModData.Update update = this.data.getUpdate();
            if (ClientServices.PLATFORM.isForge() && update != null) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int vOffset = update.animated() && (System.currentTimeMillis() / 800L & 1L) == 1L ? 8 : 0;
                graphics.method_25290(VERSION_CHECK_ICONS, left + rowWidth - 8 - 10, top + 6, (float)(update.texOffset() * 8), (float)vOffset, 8, 8, 64, 16);
            }
        }

        private class_1792 getItemIcon() {
            class_1792 item2;
            class_2960 resource;
            if (ITEM_ICON_CACHE.containsKey(this.data.getModId())) {
                return ITEM_ICON_CACHE.get(this.data.getModId());
            }
            ITEM_ICON_CACHE.put(this.data.getModId(), class_1802.field_8270);
            if (this.data.getModId().equals("forge")) {
                class_1792 item3 = class_1802.field_8782;
                ITEM_ICON_CACHE.put("forge", item3);
                return item3;
            }
            String itemIcon = this.data.getItemIcon();
            if (itemIcon != null && !itemIcon.isEmpty() && (resource = class_2960.method_12829((String)itemIcon)) != null && (item2 = (class_1792)class_7923.field_41178.method_10223(resource)) != null && item2 != class_1802.field_8162) {
                ITEM_ICON_CACHE.put(this.data.getModId(), item2);
                return item2;
            }
            Optional<class_1792> optional = class_7923.field_41178.method_10220().filter(item -> item.method_40131().method_40237().method_29177().method_12836().equals(this.data.getModId())).findFirst();
            if (optional.isPresent() && (item2 = optional.get()) != class_1802.field_8162) {
                ITEM_ICON_CACHE.put(this.data.getModId(), item2);
                return item2;
            }
            return class_1802.field_8270;
        }

        private class_2561 getFormattedModName() {
            Object name = this.data.getDisplayName();
            int width = this.list.method_25322() - (this.list.method_25331() > 0 ? 30 : 24);
            if (CatalogueModListScreen.this.field_22793.method_1727((String)name) > width) {
                name = CatalogueModListScreen.this.field_22793.method_27523((String)name, width - 10) + "...";
            }
            class_5250 title = class_2561.method_43470((String)name);
            if (this.data.getModId().equals("forge") || this.data.getModId().equals("minecraft")) {
                title.method_27692(class_124.field_1063);
            }
            return title;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            CatalogueModListScreen.this.setSelectedModData(this.data);
            this.list.method_25313((class_350.class_351)this);
            return false;
        }

        public IModData getData() {
            return this.data;
        }

        public class_2561 method_37006() {
            return class_2561.method_43470((String)this.data.getDisplayName());
        }
    }

    private record Dimension(int width, int height) {
    }

    private class StringEntry
    extends class_4280.class_4281<StringEntry> {
        private final String line;

        public StringEntry(String line) {
            this.line = line;
        }

        public void method_25343(class_332 graphics, int index, int top, int left, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            graphics.method_25303(CatalogueModListScreen.this.field_22793, this.line, left, top, 0xFFFFFF);
        }

        public class_2561 method_37006() {
            return class_2561.method_43470((String)this.line);
        }
    }
}

