/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.simple_backpack.bundle;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5536;
import net.minecraft.class_5537;
import net.minecraft.class_5630;
import net.minecraft.class_5631;
import net.minecraft.class_5632;

public class SimpleBundleItem
extends class_1792 {
    private static final int ITEM_BAR_COLOR = class_3532.method_15353((float)0.4f, (float)0.4f, (float)1.0f);
    private final int maxStorage;

    public SimpleBundleItem(class_1792.class_1793 settings, int maxStorage) {
        super(settings);
        this.maxStorage = maxStorage;
    }

    public boolean method_31568() {
        return false;
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 clickType, class_1657 player) {
        if (clickType != class_5536.field_27014) {
            return false;
        }
        class_1799 slotStack = slot.method_7677();
        if (slotStack.method_7960()) {
            SimpleBundleItem.getTopStack(slotStack).ifPresent(removedStack -> this.addToBundle(slotStack, slot.method_32756(removedStack)));
        } else if (slotStack.method_7909().method_31568()) {
            int i = (this.maxStorage - this.getBundleOccupancy(stack)) / this.getItemOccupancy(slotStack);
            this.addToBundle(stack, slot.method_32753(slotStack.method_7947(), i, player));
        }
        return true;
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (clickType == class_5536.field_27014 && slot.method_32754(player)) {
            if (otherStack.method_7960()) {
                SimpleBundleItem.getTopStack(stack).ifPresent(arg_0 -> ((class_5630)cursorStackReference).method_32332(arg_0));
            } else {
                otherStack.method_7934(this.addToBundle(stack, otherStack));
            }
            return true;
        }
        return false;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        return SimpleBundleItem.dumpBundle(stack, user) ? class_1271.method_29237((Object)stack, (boolean)world.method_8608()) : class_1271.method_22431((Object)stack);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_31567(class_1799 stack) {
        return this.getBundleOccupancy(stack) > 0;
    }

    @Environment(value=EnvType.CLIENT)
    public int method_31569(class_1799 stack) {
        return Math.min(13 * this.getBundleOccupancy(stack) / this.maxStorage, 13);
    }

    @Environment(value=EnvType.CLIENT)
    public int method_31571(class_1799 stack) {
        return ITEM_BAR_COLOR;
    }

    private int addToBundle(class_1799 bundle, class_1799 stack) {
        if (!stack.method_7960() && stack.method_7909().method_31568()) {
            class_2487 tag = bundle.method_7948();
            if (!tag.method_10545("Items")) {
                tag.method_10566("Items", (class_2520)new class_2499());
            }
            class_2499 items = tag.method_10554("Items", 10);
            BundleInventory inv = new BundleInventory(bundle, items);
            int remainder = stack.method_7947() - inv.addStack(stack).method_7947();
            tag.method_10566("Items", (class_2520)inv.getTags());
            return remainder;
        }
        return 0;
    }

    private int getItemOccupancy(class_1799 stack) {
        if (stack.method_7909() instanceof class_5537) {
            return 4 + SimpleBundleItem.getBundledStacks(stack).mapToInt(itemStack -> this.getItemOccupancy((class_1799)itemStack) * itemStack.method_7947()).sum();
        }
        if (stack.method_7909() instanceof SimpleBundleItem) {
            return 4 + this.getBundleOccupancy(stack);
        }
        return 64 / stack.method_7914();
    }

    private int getBundleOccupancy(class_1799 stack) {
        return (SimpleBundleItem)this.new BundleInventory((class_1799)stack).count;
    }

    private static Optional<class_1799> getTopStack(class_1799 itemStack) {
        class_2487 tag = itemStack.method_7948();
        if (!tag.method_10545("Items")) {
            return Optional.empty();
        }
        class_2499 items = tag.method_10554("Items", 10);
        if (items.isEmpty()) {
            return Optional.empty();
        }
        class_2487 item = items.method_10602(0);
        class_1799 stack = class_1799.method_7915((class_2487)item);
        items.method_10536(0);
        return Optional.of(stack);
    }

    private static boolean dumpBundle(class_1799 itemStack, class_1657 playerEntity) {
        class_2487 tag = itemStack.method_7948();
        if (!tag.method_10545("Items")) {
            return false;
        }
        if (playerEntity.method_5715()) {
            if (playerEntity instanceof class_3222) {
                class_2499 items = tag.method_10554("Items", 10);
                for (int i = 0; i < items.size(); ++i) {
                    class_2487 item = items.method_10602(i);
                    class_1799 stack = class_1799.method_7915((class_2487)item);
                    playerEntity.method_7328(stack, true);
                }
            }
            itemStack.method_7983("Items");
            return true;
        }
        return false;
    }

    private static Stream<class_1799> getBundledStacks(class_1799 stack) {
        class_2487 compoundTag = stack.method_7969();
        if (compoundTag == null) {
            return Stream.empty();
        }
        class_2499 listTag = compoundTag.method_10554("Items", 10);
        return listTag.stream().map(class_2487.class::cast).map(class_1799::method_7915);
    }

    @Environment(value=EnvType.CLIENT)
    public Optional<class_5632> method_32346(class_1799 stack) {
        class_2371 defaultedList = class_2371.method_10211();
        SimpleBundleItem.getBundledStacks(stack).forEach(arg_0 -> defaultedList.add(arg_0));
        return Optional.of(new class_5631(defaultedList, (int)((float)this.getBundleOccupancy(stack) / (float)this.maxStorage * 64.0f)));
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        tooltip.add((class_2561)class_2561.method_43469((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{this.getBundleOccupancy(stack), this.maxStorage}).method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simple_backpack.simple_bundle.tip1").method_27692(class_124.field_1054));
    }

    private class BundleInventory
    implements class_1263 {
        private final class_1799 bundle;
        private final List<class_1799> stacks = class_2371.method_10211();
        public int count;

        private BundleInventory(class_1799 bundle) {
            this.bundle = bundle;
            if (bundle.method_7985() && bundle.method_7969().method_10545("Items")) {
                this.readNbt(bundle.method_7969().method_10554("Items", 10));
            }
        }

        private BundleInventory(class_1799 bundle, class_2499 nbtList) {
            this.bundle = bundle;
            this.readNbt(nbtList);
        }

        public class_1799 addStack(class_1799 stack) {
            class_1799 insertStack = stack.method_7972();
            int itemOccupancy = SimpleBundleItem.this.getItemOccupancy(stack);
            int insertCount = Math.min(stack.method_7947(), (SimpleBundleItem.this.maxStorage - this.count) / itemOccupancy);
            if (insertCount == 0) {
                return insertStack;
            }
            int remainder = insertStack.method_7947() - insertCount;
            insertStack.method_7939(insertCount);
            this.addToExistingSlot(insertStack);
            if (insertStack.method_7960()) {
                class_1799 ret = stack.method_7972();
                ret.method_7939(remainder);
                return ret;
            }
            this.addToNewSlot(insertStack);
            if (insertStack.method_7960()) {
                class_1799 ret = stack.method_7972();
                ret.method_7939(remainder);
                return ret;
            }
            insertStack.method_7933(remainder);
            return insertStack;
        }

        private void addToExistingSlot(class_1799 stack) {
            for (int i = 0; i < this.method_5439(); ++i) {
                class_1799 itemStack = this.method_5438(i);
                if (!class_1799.method_31577((class_1799)itemStack, (class_1799)stack)) continue;
                this.transfer(stack, itemStack);
                if (!stack.method_7960()) continue;
                return;
            }
        }

        public void readNbt(class_2499 tags) {
            for (int i = tags.size(); i >= 0; --i) {
                class_1799 itemStack = class_1799.method_7915((class_2487)tags.method_10602(i));
                if (itemStack.method_7960()) continue;
                this.addStack(itemStack);
            }
            this.method_5431();
        }

        public class_2499 getTags() {
            class_2499 listTag = new class_2499();
            for (int i = 0; i < this.method_5439(); ++i) {
                class_1799 itemStack = this.method_5438(i);
                if (itemStack.method_7960()) continue;
                listTag.add((Object)itemStack.method_7953(new class_2487()));
            }
            return listTag;
        }

        private void transfer(class_1799 source, class_1799 target) {
            int i = Math.min(this.method_5444(), target.method_7914());
            int j = Math.min(source.method_7947(), i - target.method_7947());
            if (j > 0) {
                target.method_7933(j);
                source.method_7934(j);
                this.method_5431();
            }
        }

        private void addToNewSlot(class_1799 stack) {
            this.stacks.add(0, stack.method_7972());
            stack.method_7939(0);
        }

        public int method_5439() {
            return this.stacks.size();
        }

        public boolean method_5442() {
            for (class_1799 stack : this.stacks) {
                if (stack.method_7960()) continue;
                return false;
            }
            return true;
        }

        public class_1799 method_5438(int slot) {
            return slot >= 0 && slot < this.stacks.size() ? this.stacks.get(slot) : class_1799.field_8037;
        }

        public class_1799 method_5434(int slot, int amount) {
            class_1799 itemStack = class_1262.method_5430(this.stacks, (int)slot, (int)amount);
            if (!itemStack.method_7960()) {
                this.method_5431();
            }
            return itemStack;
        }

        public class_1799 method_5441(int slot) {
            class_1799 itemStack = this.stacks.get(slot);
            if (itemStack.method_7960()) {
                return class_1799.field_8037;
            }
            this.stacks.set(slot, class_1799.field_8037);
            return itemStack;
        }

        public void method_5447(int slot, class_1799 stack) {
            if (slot < this.stacks.size()) {
                this.stacks.set(slot, stack);
            } else {
                this.stacks.add(stack);
            }
            if (!stack.method_7960() && stack.method_7947() > this.method_5444()) {
                stack.method_7939(this.method_5444());
            }
        }

        public void method_5431() {
            this.updateCount();
        }

        public boolean method_5443(class_1657 player) {
            return true;
        }

        public void method_5448() {
            this.stacks.clear();
            this.method_5431();
        }

        private void updateCount() {
            this.count = 0;
            for (class_1799 stack : this.stacks) {
                this.count += SimpleBundleItem.this.getItemOccupancy(stack) * stack.method_7947();
            }
        }
    }
}

