/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.pipeline;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Comparator;
import java.util.PriorityQueue;
import network.ycc.raknet.RakNet;
import network.ycc.raknet.frame.Frame;
import network.ycc.raknet.packet.FrameSet;
import network.ycc.raknet.packet.Reliability;
import network.ycc.raknet.pipeline.FlushTickHandler;
import network.ycc.raknet.utils.Constants;
import network.ycc.raknet.utils.UINT;

public class ReliabilityHandler
extends ChannelDuplexHandler {
    public static final String NAME = "rn-reliability";
    protected final IntSortedSet nackSet = new IntRBTreeSet((Comparator)UINT.B3.COMPARATOR);
    protected final IntSortedSet ackSet = new IntRBTreeSet((Comparator)UINT.B3.COMPARATOR);
    protected final PriorityQueue<Frame> frameQueue = new PriorityQueue<Frame>(Frame.COMPARATOR);
    protected final Int2ObjectLinkedOpenHashMap<FrameSet> pendingFrameSets = new Int2ObjectLinkedOpenHashMap();
    protected int queuedBytes = 0;
    protected int lastReceivedSeqId = 0;
    protected int nextSendSeqId = 0;
    protected int resendGauge = 0;
    protected int burstTokens = 0;
    protected RakNet.Config config = null;
    protected ChannelHandlerContext ctx;
    protected Runnable frameSetProduction = () -> {
        this.produceFrameSets(this.ctx);
        this.ctx.flush();
    };

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.config = RakNet.config(ctx);
        this.ctx = ctx;
        ctx.channel().attr(RakNet.WRITABLE).set((Object)true);
        if (this.config.isIgnoreResendGauge()) {
            this.resendGauge = 2;
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.clearQueue(null);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof Frame) {
            Frame frame = (Frame)((Object)msg);
            this.queueFrame(frame);
            frame.setPromise(promise);
        } else {
            ctx.write(msg, promise);
        }
        Constants.packetLossCheck(this.pendingFrameSets.size(), "unconfirmed sent packets");
        FlushTickHandler.checkFlushTick(ctx.channel());
    }

    public void flush(ChannelHandlerContext ctx) {
        if (!ctx.channel().isOpen()) {
            ctx.flush();
            return;
        }
        this.sendResponses(ctx);
        this.recallExpiredFrameSets();
        this.produceFrameSets(ctx);
        this.updateBurstTokens(1);
        this.updateBackPressure(ctx);
        Constants.packetLossCheck(this.pendingFrameSets.size(), "resend queue");
        ctx.flush();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof FlushTickHandler.MissedFlushes) {
            this.updateBurstTokens(((FlushTickHandler.MissedFlushes)evt).nFlushes);
        }
        ctx.fireUserEventTriggered(evt);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        try {
            if (msg instanceof Reliability.ACK) {
                this.readAck((Reliability.ACK)msg);
            } else if (msg instanceof Reliability.NACK) {
                this.readNack((Reliability.NACK)msg);
            } else if (msg instanceof FrameSet) {
                this.readFrameSet(ctx, (FrameSet)msg);
            } else {
                ctx.fireChannelRead(ReferenceCountUtil.retain((Object)msg));
            }
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    protected void clearQueue(Throwable t) {
        if (t != null) {
            this.frameQueue.forEach(frame -> {
                if (frame.getPromise() != null) {
                    frame.getPromise().tryFailure(t);
                }
            });
            this.pendingFrameSets.values().forEach(set -> set.fail(t));
        }
        this.frameQueue.forEach(AbstractReferenceCounted::release);
        this.frameQueue.clear();
        this.queuedBytes = 0;
        this.pendingFrameSets.values().forEach(AbstractReferenceCounted::release);
        this.pendingFrameSets.clear();
    }

    protected void readFrameSet(ChannelHandlerContext ctx, FrameSet frameSet) {
        int packetSeqId = frameSet.getSeqId();
        this.ackSet.add(packetSeqId);
        if (this.config.isNACKEnabled()) {
            this.nackSet.remove(packetSeqId);
        }
        if (UINT.B3.minusWrap(packetSeqId, this.lastReceivedSeqId) > 0) {
            this.lastReceivedSeqId = UINT.B3.plus(this.lastReceivedSeqId, 1);
            while (this.lastReceivedSeqId != packetSeqId) {
                if (this.config.isNACKEnabled()) {
                    this.nackSet.add(this.lastReceivedSeqId);
                }
                this.lastReceivedSeqId = UINT.B3.plus(this.lastReceivedSeqId, 1);
            }
        }
        this.config.getMetrics().packetsIn(1);
        this.config.getMetrics().framesIn(frameSet.getNumPackets());
        frameSet.createFrames(arg_0 -> ((ChannelHandlerContext)ctx).fireChannelRead(arg_0));
        this.trySendResponses(ctx);
        ctx.fireChannelReadComplete();
    }

    protected void readAck(Reliability.ACK ack) {
        int ackdBytes = 0;
        int nIterations = 0;
        for (Reliability.REntry entry : ack.getEntries()) {
            int max = UINT.B3.plus(entry.idFinish, 1);
            int id = entry.idStart;
            while (id != max) {
                FrameSet frameSet = (FrameSet)this.pendingFrameSets.remove(id);
                if (frameSet != null) {
                    ackdBytes += frameSet.getRoughSize();
                    this.adjustResendGauge(1);
                    frameSet.succeed();
                    frameSet.release();
                    this.tryProduceFrameSets();
                }
                Constants.packetLossCheck(nIterations++, "ack confirm range");
                id = UINT.B3.plus(id, 1);
            }
        }
        this.config.getMetrics().bytesACKd(ackdBytes);
    }

    protected void readNack(Reliability.NACK nack) {
        if (!this.config.isNACKEnabled()) {
            return;
        }
        int bytesNACKd = 0;
        int nIterations = 0;
        for (Reliability.REntry entry : nack.getEntries()) {
            int max = UINT.B3.plus(entry.idFinish, 1);
            int id = entry.idStart;
            while (id != max) {
                FrameSet frameSet = (FrameSet)this.pendingFrameSets.remove(id);
                if (frameSet != null) {
                    bytesNACKd += frameSet.getRoughSize();
                    this.recallFrameSet(frameSet);
                }
                Constants.packetLossCheck(nIterations++, "nack confirm range");
                id = UINT.B3.plus(id, 1);
            }
        }
        this.config.getMetrics().bytesNACKd(bytesNACKd);
    }

    protected void queueFrame(Frame frame) {
        int roughPacketSize = frame.getRoughPacketSize();
        if (roughPacketSize > this.config.getMTU()) {
            throw new CorruptedFrameException("Finished frame larger than the MTU by " + (roughPacketSize - this.config.getMTU()));
        }
        this.frameQueue.add(frame);
        this.queuedBytes += roughPacketSize;
        this.config.getMetrics().currentQueuedBytes(this.queuedBytes);
    }

    protected void adjustResendGauge(int n) {
        if (this.config.isIgnoreResendGauge()) {
            this.resendGauge = 2;
            return;
        }
        this.resendGauge = Math.max(-this.config.getDefaultPendingFrameSets(), Math.min(this.config.getDefaultPendingFrameSets(), this.resendGauge + n));
    }

    protected void updateBurstTokens(int nTicks) {
        if (this.config.isNoDelayEnabled()) {
            this.burstTokens = Math.max(0, this.config.getMaxPendingFrameSets());
        } else {
            boolean burstUnused;
            boolean bl = burstUnused = this.pendingFrameSets.size() < this.burstTokens / 2;
            if (this.resendGauge > 1 && !burstUnused) {
                this.burstTokens += 1 * nTicks;
            } else if (this.resendGauge < -1 || burstUnused) {
                this.burstTokens -= 3 * nTicks;
            }
            this.burstTokens = Math.max(Math.min(this.burstTokens, this.config.getMaxPendingFrameSets()), 0);
        }
        this.config.getMetrics().measureBurstTokens(this.burstTokens);
    }

    protected void sendResponses(ChannelHandlerContext ctx) {
        if (!this.ackSet.isEmpty()) {
            ctx.write((Object)new Reliability.ACK(this.ackSet)).addListener((GenericFutureListener)RakNet.INTERNAL_WRITE_LISTENER);
            this.config.getMetrics().acksSent(this.ackSet.size());
            this.ackSet.clear();
        }
        if (this.config.isNACKEnabled() && !this.nackSet.isEmpty() && this.config.isAutoRead()) {
            ctx.write((Object)new Reliability.NACK(this.nackSet)).addListener((GenericFutureListener)RakNet.INTERNAL_WRITE_LISTENER);
            this.config.getMetrics().nacksSent(this.nackSet.size());
            this.nackSet.clear();
        }
    }

    protected void trySendResponses(ChannelHandlerContext ctx) {
        if (this.ackSet.size() >= this.config.getDefaultPendingFrameSets() - 1) {
            this.sendResponses(ctx);
            ctx.flush();
        }
    }

    protected void recallExpiredFrameSets() {
        FrameSet frameSet;
        ObjectIterator packetItr = this.pendingFrameSets.values().iterator();
        long deadline = System.nanoTime() - (this.config.getRTTNanos() + 2L * this.config.getRTTStdDevNanos() + this.config.getRetryDelayNanos());
        while (packetItr.hasNext() && (frameSet = (FrameSet)packetItr.next()).getSentTime() < deadline) {
            packetItr.remove();
            this.recallFrameSet(frameSet);
        }
    }

    protected void produceFrameSet(ChannelHandlerContext ctx, int maxSize) {
        Frame frame;
        if (this.frameQueue.isEmpty()) {
            return;
        }
        FrameSet frameSet = FrameSet.create();
        while ((frame = this.frameQueue.peek()) != null) {
            assert (frame.refCnt() > 0) : "Frame has lost reference";
            int roughPacketSize = frame.getRoughPacketSize();
            if (frameSet.getRoughSize() + roughPacketSize > maxSize) {
                if (!frameSet.isEmpty()) break;
                throw new CorruptedFrameException("Finished frame larger than the MTU by " + (roughPacketSize - maxSize));
            }
            this.frameQueue.poll();
            this.queuedBytes -= roughPacketSize;
            frameSet.addPacket(frame);
        }
        if (!frameSet.isEmpty()) {
            frameSet.setSeqId(this.nextSendSeqId);
            this.nextSendSeqId = UINT.B3.plus(this.nextSendSeqId, 1);
            this.pendingFrameSets.put(frameSet.getSeqId(), (Object)frameSet);
            frameSet.touch("Added to pending FrameSet list");
            ctx.write((Object)frameSet.retain()).addListener((GenericFutureListener)RakNet.INTERNAL_WRITE_LISTENER);
            this.config.getMetrics().packetsOut(1);
            this.config.getMetrics().framesOut(frameSet.getNumPackets());
            this.config.getMetrics().currentQueuedBytes(this.queuedBytes);
            assert (frameSet.refCnt() > 0);
        } else {
            frameSet.release();
        }
    }

    protected void produceFrameSets(ChannelHandlerContext ctx) {
        int mtu = this.config.getMTU();
        int maxSize = mtu - 4 - 24;
        int maxPendingFrameSets = this.config.getDefaultPendingFrameSets() + this.burstTokens;
        while (this.pendingFrameSets.size() < maxPendingFrameSets && !this.frameQueue.isEmpty()) {
            this.produceFrameSet(ctx, maxSize);
        }
    }

    protected void tryProduceFrameSets() {
        this.ctx.executor().execute(this.frameSetProduction);
    }

    protected void recallFrameSet(FrameSet frameSet) {
        try {
            this.adjustResendGauge(-1);
            this.config.getMetrics().bytesRecalled(frameSet.getRoughSize());
            frameSet.touch("Recalled");
            frameSet.createFrames(frame -> {
                if (frame.getReliability().isReliable) {
                    this.queueFrame((Frame)((Object)frame));
                } else {
                    frame.getPromise().trySuccess();
                    frame.release();
                }
            });
            this.tryProduceFrameSets();
        }
        finally {
            frameSet.release();
        }
    }

    protected void updateBackPressure(ChannelHandlerContext ctx) {
        boolean oldWritable;
        int queuedBytes = this.getQueuedBytes();
        boolean newWritable = oldWritable = ((Boolean)ctx.channel().attr(RakNet.WRITABLE).get()).booleanValue();
        if (queuedBytes > this.config.getMaxQueuedBytes()) {
            CodecException t = new CodecException("Frame queue is too large");
            this.clearQueue((Throwable)t);
            ctx.close();
            throw t;
        }
        if (queuedBytes > this.config.getWriteBufferHighWaterMark()) {
            newWritable = false;
        } else if (queuedBytes < this.config.getWriteBufferLowWaterMark()) {
            newWritable = true;
        }
        if (newWritable != oldWritable) {
            ctx.channel().attr(RakNet.WRITABLE).set((Object)(newWritable ? Boolean.TRUE : Boolean.FALSE));
            ctx.fireChannelWritabilityChanged();
        }
    }

    protected int getQueuedBytes() {
        return this.queuedBytes;
    }
}

