/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.packet;

import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import network.ycc.raknet.RakNet;
import network.ycc.raknet.config.DefaultMagic;
import network.ycc.raknet.packet.AbstractConnectionReply;
import network.ycc.raknet.packet.Packet;

public class ConnectionReply2
extends AbstractConnectionReply
implements Packet {
    private InetSocketAddress address = null;

    public ConnectionReply2() {
    }

    public ConnectionReply2(RakNet.Magic magic, int mtu, long serverId, InetSocketAddress address) {
        super(magic, mtu, serverId);
        this.address = address;
    }

    @Override
    public void encode(ByteBuf buf) {
        this.magic.write(buf);
        buf.writeLong(this.serverId);
        if (this.address == null) {
            ConnectionReply2.writeAddress(buf);
        } else {
            ConnectionReply2.writeAddress(buf, this.address);
        }
        buf.writeShort(this.mtu);
        buf.writeBoolean(false);
    }

    @Override
    public void decode(ByteBuf buf) {
        this.magic = DefaultMagic.decode(buf);
        this.serverId = buf.readLong();
        this.address = ConnectionReply2.readAddress(buf);
        this.mtu = buf.readShort();
        if (buf.readBoolean()) {
            throw new IllegalArgumentException("No security support yet");
        }
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetSocketAddress address) {
        this.address = address;
    }
}

